package common

import (
	"context"
	"encoding/json"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/resource/redisCli"
	"git.hilo.cn/hilo-common/utils"
	"hilo-group/_const/redis_key"
	"hilo-group/myerr"
	"time"
)

func GetUserMedalMergeCache(userId mysql.ID) ([]uint32, error) {
	bData, err := GetCache(redis_key.GetUserMedalMerge(userId))
	if err != nil {
		return nil, myerr.WrapErr(err)
	}

	res := make([]uint32, 0)
	err = json.Unmarshal(bData, &res)
	if err != nil {
		return nil, myerr.WrapErr(err)
	}
	return res, nil
}

func SetUserMedalMergeCache(userId mysql.ID, data []uint32) error {
	err := SetCache(redis_key.GetUserMedalMerge(userId), data, time.Hour*2)
	if err != nil {
		mylogrus.MyLog.Errorf("SetUserMedalMerge err:%s", err)
		return myerr.WrapErr(err)
	}
	return nil
}

// 删除勋章缓存, 延迟删除
func DelUserMedalMergeCacheDelay(userId mysql.ID) {
	go func() {
		defer utils.CheckGoPanic()
		time.Sleep(time.Second * 5)
		DelUserMedalMergeCache(userId)
	}()
}

func DelUserMedalMergeCache(userId mysql.ID) error {
	err := DelCache(redis_key.GetUserMedalMerge(userId))
	if err != nil {
		mylogrus.MyLog.Errorf("DetUserMedalMerge err:%s, userId:%v", err, userId)
		return myerr.WrapErr(err)
	}
	return nil
}

func DelCache(key string) error {
	err := redisCli.GetRedis().Del(context.Background(), key).Err()
	if err != nil {
		mylogrus.MyLog.Errorf("DelCache key:%s, err:%s", key, err)
		return err
	}
	return nil
}

func GetCache(key string) ([]byte, error) {
	data, err := redisCli.GetRedis().Get(context.Background(), key).Bytes()
	if err != nil {
		return nil, err
	}
	return data, nil
}

func SetCache(key string, data interface{}, expire time.Duration) error {
	jData, err := json.Marshal(data)
	if err != nil {
		return err
	}
	err = redisCli.GetRedis().Set(context.Background(), key, jData, expire).Err()
	if err != nil {
		mylogrus.MyLog.Errorf("SetCache key:%s, data:%v, err:%s", key, data, err)
		return err
	}
	return nil
}
