package mic_r

import (
	"git.hilo.cn/hilo-common/_const/enum/timezone_e"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/gin-gonic/gin"
	"hilo-group/domain/model/mic_m"
	"hilo-group/resp"
)

type MGetUserOnMicSecondsReq struct {
	Day string              `form:"day" binding:"required"`
	Ids []mysql.ID          `form:"ids" binding:"required"`
	Tz  timezone_e.Timezone `form:"tz"`
}

// @Tags 麦位-内部
// @Summary 批量获取用户天上麦时长
// @Param day query string true "天 格式2006-001-02"
// @Param ids query string true "用户id,如:ids=1&ids=2&ids=3"
// @Param tz query string false "时区 0:北京时间(默认) 1:沙特时间"
// @Success 200 {object} map[uint64]uint32
// @Router /inner/mic/onMicSeconds [get]
func MGetUserOnMicSeconds(c *gin.Context) (*mycontext.MyContext, error) {
	myCtx := mycontext.CreateMyContext(c.Keys)
	var model = domain.CreateModelContext(myCtx)
	var req MGetUserOnMicSecondsReq
	if err := c.ShouldBindQuery(&req); err != nil {
		return myCtx, err
	}
	onMic, err := mic_m.MGetUserOnMicSeconds(model, req.Day, req.Tz, req.Ids)
	if err != nil {
		return myCtx, err
	}
	response := onMic
	resp.ResponseOk(c, response)
	return myCtx, nil
}

type MGetUserOnMicSecondsRangeReq struct {
	BeginDate string              `form:"beginDate" binding:"required"`
	EndDate   string              `form:"endDate" binding:"required"`
	Ids       []mysql.ID          `form:"ids" binding:"required"`
	Tz        timezone_e.Timezone `form:"tz"`
}

// @Tags 麦位-内部
// @Summary 批量获取用户范围上麦时长
// @Param beginDate query string true "天 格式2006-001-02"
// @Param endDate query string true "天 格式2006-001-02"
// @Param ids query string true "用户id,如:ids=1&ids=2&ids=3"
// @Param tz query string false "时区 0:北京时间(默认) 1:沙特时间"
// @Success 200 {object} map[uint64]uint32
// @Router /inner/mic/onMicSeconds/range [get]
func MGetUserOnMicSecondsRange(c *gin.Context) (*mycontext.MyContext, error) {
	myCtx := mycontext.CreateMyContext(c.Keys)
	var model = domain.CreateModelContext(myCtx)
	var req MGetUserOnMicSecondsRangeReq
	if err := c.ShouldBindQuery(&req); err != nil {
		return myCtx, err
	}
	onMic, err := mic_m.MGetUserOnMicSecondsRange(model, req.BeginDate, req.EndDate, req.Tz, req.Ids)
	if err != nil {
		return myCtx, err
	}
	response := onMic
	resp.ResponseOk(c, response)
	return myCtx, nil
}
