package group_m

import "git.hilo.cn/hilo-common/domain"

// 获取游戏房
func GetGameGroupsMap(model *domain.Model) map[string]bool {
	res := make(map[string]bool)
	var rows []GroupInfo
	if err := model.DB().Model(GroupInfo{}).Where("is_game_room = 1").Find(&rows).Error; err != nil {
		model.Log.Errorf("GetGameGroupsMap fail:%v", err)
		return res
	}
	for _, v := range rows {
		res[v.ImGroupId] = true
	}
	return res
}
