package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"gorm.io/gorm"
)

type GroupTop struct {
	Id        uint
	ImGroupId string
}

func (g *GroupTop) PutOnTop(model *domain.Model) error {
	err := model.Db.Model(&GroupTop{}).Where("id > 0").Order("id DESC").UpdateColumn("id", gorm.Expr("id + ?", 1)).Error
	if err != nil {
		return err
	}
	g.Id = 1
	return model.Db.Create(g).Error
}

func (g *GroupTop) Delete(model *domain.Model) error {
	return model.Db.Where(g).Delete(&GroupTop{}).Error
}

func GroupTopGetAll(model *domain.Model, area int) ([]string, error) {
	rows := make([]GroupTop, 0)
	err := model.DB().Table("group_top").
		Joins("left join group_info gi on group_top.im_group_id = gi.im_group_id "+
			"left join res_country rc on gi.country = rc.name").
		Where("rc.area = ?", area).
		Order("group_top.id").Find(&rows).Error
	if err != nil {
		return nil, err
	}
	result := make([]string, 0)
	for _, i := range rows {
		result = append(result, i.ImGroupId)
	}
	return result, err
}
