package event_s

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/protocol/userProxy"
	"git.hilo.cn/hilo-common/rpc"
	uuid "github.com/satori/go.uuid"
	"hilo-group/domain/event/group_ev"
	"hilo-group/domain/model/group_m"
	"hilo-group/myerr/bizerr"
)

// 用户进房后推送mic信息
func GroupInMicChangeEvent() {
	group_ev.AddTxGroupInEventAsync(func(model *domain.Model, event interface{}) error {
		e, ok := event.(*group_ev.TxGroupInEvent)
		if !ok {
			return bizerr.InvalidParameter
		}
		return MicAllRPush(model, e.GroupId, e.UserId, e.ExternalId)
	})
}

func MicAllRPush(model *domain.Model, imGroupId string, userId uint64, externalId string) error {
	model.Log.Infof("MicChangeRPush MicAllRPush begin groupUuid:%v, externalId:%v", imGroupId, externalId)

	txGroupId, err := group_m.ToTxGroupId(model, imGroupId)
	if err != nil {
		model.Log.Errorf("ToImGroupId fail:%v", err)
		return err
	}
	//
	micContents, err := group_m.GetMicAllContent(model, imGroupId)
	if err != nil {
		model.Log.Errorf("MicChangeRPush MicAllRPush getMicAllContent  err:%+v, micContents:%v groupUuid:%v, externalId:%v", err, micContents, txGroupId, externalId)
		return err
	}
	for _, micContent := range micContents {
		//麦上是默认值，就不用推
		if micContent.Forbid == false && micContent.User == nil && micContent.AgoraId == 0 && micContent.Lock == false && micContent.ExternalId == "" && micContent.MicForbid == false {
			model.Log.Infof("MicChangeRPush MicAllRPush default micContent:%v, groupUuid:%v, externalId:%v, micContent:%+v", micContent, txGroupId, externalId, micContent)
			continue
		}
		micContentStr, err := json.Marshal(micContent)
		if err != nil {
			continue
		}
		var micExternalId string
		var micUserData *userProxy.MicUserData
		if micContent.User != nil {
			micExternalId = micContent.ExternalId
			micUserData = &userProxy.MicUserData{
				Id:                       micContent.User.Id,
				ExternalId:               micContent.User.ExternalId,
				Avatar:                   micContent.User.Avatar,
				Nick:                     micContent.User.Nick,
				Sex:                      uint32(micContent.User.Sex),
				Code:                     micContent.User.Code,
				IsVip:                    micContent.User.IsVip,
				Noble:                    uint32(micContent.User.NobleLeave),
				HeadwearPicUrl:           micContent.User.HeadwearPicUrl,
				HeadwearEffectUrl:        micContent.User.HeadwearEffectUrl,
				HeadwearReverseEffectUrl: micContent.User.HeadwearReverseEffectUrl,
				SvipLevel:                uint32(micContent.User.SvipLevel),
				MicEffect:                micContent.User.MicEffect,
				HeadwearIcon:             micContent.User.HeadwearIcon,
				Svip:                     nil,
			}
			if micContent.User.Svip.SvipLevel > 0 || len(micContent.User.Svip.Privileges) > 0 {
				micUserData.Svip = &userProxy.Svip{
					SvipLevel: uint64(micContent.User.SvipLevel),
				}
				for _, v := range micContent.User.Svip.Privileges {
					micUserData.Svip.Privileges = append(micUserData.Svip.Privileges, &userProxy.SvipPrivilege{
						Type:        int32(v.Type),
						CanSwitch:   v.CanSwitch,
						UserSwitch:  v.UserSwitch,
						MysteryCode: v.MysteryCode,
					})
				}
			}
		}
		seqId := uuid.NewV4().String()

		if err := rpc.SendSocketMicChange(seqId, userId, micExternalId, txGroupId, uint32(micContent.I), micContent.Lock, micContent.Forbid, micContent.MicForbid, micContent.AgoraId, micUserData); err != nil {
			model.Log.Errorf("MicAllRPush err:%+v, groupUuid:%v, externalId:%v, micContent:%+v", err, txGroupId, externalId, string(micContentStr))
		} else {
			model.Log.Infof("MicChangeRPush MicAllRPush Marshal micContent, groupUuid:%v, externalId:%v, micContent:%+v", txGroupId, externalId, string(micContentStr))
		}
	}
	model.Log.Infof("MicAllRPush end groupUuid:%v, externalId:%v", txGroupId, externalId)
	return nil
}
