package group_cron

import (
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/config"
	"hilo-group/domain/service/event_s"
	"time"
)

// 进房事件
func GroupInEventInit() {
	if !config.IsMaster() {
		return
	}
	mylogrus.MyLog.Infof("GroupInEventInit")
	go func() {
		ticker := time.NewTicker(time.Millisecond * 500)
		defer ticker.Stop()
		for {
			select {
			case <-ticker.C:
				//start := time.Now()
				myCtx := mycontext.CreateMyContext(nil)
				// 消费进房事件
				if err := event_s.NewGroupInEventService(myCtx).Consume(); err != nil {
					myCtx.Log.Errorf("groupInEvent consume fail:%v", err)
				} else {
					//myCtx.Log.Infof("groupInEvent consume success,cost:%v", time.Now().Sub(start))
				}
			}
		}
	}()
}
