package mic_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"github.com/robfig/cron"
	"hilo-group/domain/event/mic_ev"
	"hilo-group/domain/model/group_m"
)

func OnMicCheck() {
	c := cron.New()
	//一分钟执行一次
	spec := "0 */1 * * * ?"
	_ = c.AddFunc(spec, func() {
		//获取麦上的所有人
		var model = domain.CreateModelNil()
		groupIds, err := group_m.GetMicHasInGroups()
		if err != nil {
			model.Log.Errorf("cron micIn GetMicHasInGroups err:%v", err)
			return
		}
		for _, groupId := range groupIds {
			//遍历每个麦位
			for i := 1; i <= 30; i++ {
				micUser, err := group_m.GetMicUser(model, groupId, i)
				if err != nil {
					model.Log.Errorf("cron micIn group_m.GetMicUser err:%v", err)
				}
				if micUser != nil {
					if err := mic_ev.PublishOnMicEvent(model, &mic_ev.OnMicEvent{
						GroupUuid:  micUser.GroupUuid,
						I:          micUser.I,
						ExternalId: micUser.ExternalId,
						UserId:     micUser.UserId,
						Forbid:     micUser.Forbid,
						Timestamp:  micUser.Timestamp,
					}); err != nil {
						model.Log.Errorf("PublishOnMicEvent fail:%v", err)
					}
				}
			}
		}
	})
	c.Start()
}
