package groupPower_m

import (
	"git.hilo.cn/hilo-common/domain"
	"gorm.io/gorm"
	"hilo-group/common"
	"hilo-group/myerr"
	"hilo-group/myerr/bizerr"
	"time"
)

type GroupPowerApplyJoin struct {
	Id           uint64    `json:"id"`
	UserId       uint64    `json:"user_id"`
	GroupPowerId uint64    `json:"group_power_id"`
	CreatedTime  time.Time `json:"created_time"`
	UpdatedTime  time.Time `json:"updated_time"`
	IsAccept     int8      `json:"is_accept"`
	MgrId        uint64    `json:"mgr_id"`
}

func InsertGroupPowerApplyJoin(model *domain.Model, userId, familyId uint64) error {
	sql := "insert into group_power_apply_join(user_id,group_power_id,is_accept) " +
		"select ?, ?, ? where not exists (select id from group_power_apply_join where user_id=? and group_power_id=? and is_accept=0)"
	result := model.Db.Exec(sql, userId, familyId, 0, userId, familyId)
	if result.Error != nil {
		return myerr.WrapErr(result.Error)
	}
	if result.RowsAffected <= 0 {
		return myerr.WrapErr(bizerr.GroupPowerHaveAlreadyApply)
	}
	return nil
}

func GetGroupPowerApplyJoin(model *domain.Model, userId, familyId uint64, isAccept int) (*GroupPowerApplyJoin, error) {
	res := new(GroupPowerApplyJoin)
	db := model.Db.Where(GroupPowerApplyJoin{UserId: userId, GroupPowerId: familyId})
	if isAccept != -1 {
		db = db.Where("is_accept=?", isAccept)
	}
	err := db.First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return res, nil
}

func OptGroupPowerApplyJoinById(model *domain.Model, id, mgrId uint64, optType int) error {
	err := model.Db.Exec("update group_power_apply_join set is_accept = ?, mgr_id = ? where id=? and is_accept = 0", optType, mgrId, id).Error
	if err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func AcceptGroupPowerApplyJoin(model *domain.Model, userId, familyId uint64) error {
	err := model.Db.Exec("update group_power_apply_join set is_accept = 1 where user_id=? and group_power_id=?", userId, familyId).Error
	if err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func OptGroupPowerApplyList(model *domain.Model, familyId uint64, pageSize, pageIndex int) ([]*GroupPowerApplyJoin, int, bool, error) {
	rows := make([]*GroupPowerApplyJoin, 0)
	db := model.Db.Model(GroupPowerApplyJoin{}).Where("group_power_id = ?", familyId).Order("is_accept, created_time desc")
	var count int64
	err := db.Count(&count).Error
	if err != nil {
		return nil, 0, false, err
	}
	err = db.Limit(pageSize).Offset(pageIndex).Find(&rows).Error
	if err != nil {
		return nil, 0, false, err
	}
	nextIdx, hasNext := common.PageNext(count, pageIndex, pageSize)
	return rows, nextIdx, hasNext, nil
}
