package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"hilo-group/myerr"
)

//群组勋章
type GroupMedal struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	ImGroupId     string
	ResMedalId    uint64
}

func (gm *GroupMedal) Create(db *gorm.DB) (int64, error) {
	result := db.Clauses(clause.OnConflict{DoNothing: true}).Create(gm)
	return result.RowsAffected, result.Error
}

//增加群组勋章
func (groupInfo *GroupInfo) GroupMedalMgrAdd(model *domain.Model, resMedalId uint64) *GroupMedal {
	return &GroupMedal{
		Model:      model,
		ImGroupId:  groupInfo.ImGroupId,
		ResMedalId: resMedalId,
	}
}


func GetGroupMedalOrErr(model *domain.Model, id mysql.ID) (*GroupMedal, error) {
	groupMedal := GroupMedal{}
	if err := model.Db.Model(&GroupMedal{}).First(&groupMedal, id).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	groupMedal.Model = model
	return &groupMedal, nil
}

func GetGroupMedalOrInit(model *domain.Model, imGroupId string, resMedalId mysql.ID) (*GroupMedal, error) {
	groupMedal := GroupMedal{}
	if err := model.Db.Model(&GroupMedal{}).Where(&GroupMedal{
		ImGroupId:  imGroupId,
		ResMedalId: resMedalId,
	}).First(&groupMedal).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return &GroupMedal{
				Model:      model,
				ImGroupId:  imGroupId,
				ResMedalId: resMedalId,
			}, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	groupMedal.Model = model
	return &groupMedal, nil
}

func BatchGetMedals(db *gorm.DB, groupIds []string) (map[string][]uint64, error) {
	if len(groupIds) <= 0 {
		return nil, nil
	}
	rows := make([]GroupMedal, 0)
	if err := db.Model(&GroupMedal{}).Where("im_group_id IN ?", groupIds).Find(&rows).Error; err != nil {
		return nil, err
	}
	result := make(map[string][]uint64, 0)
	for _, i := range rows {
		if _, ok := result[i.ImGroupId]; !ok {
			result[i.ImGroupId] = make([]uint64, 0)
		}
		result[i.ImGroupId] = append(result[i.ImGroupId], i.ResMedalId)
	}
	return result, nil
}

//移除群组勋章
func (groupMedal *GroupMedal) GroupMedalMgrDel() *GroupMedal {
	groupMedal.SetDel()
	return groupMedal
}
