package mic_k

import (
	"fmt"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/redis_key"
	"time"
)

const (
	MicPrefix    = "mic:"
	MicDayInvite = MicPrefix + "day:invite:${userId}:${date}" // string 自动被邀请上麦,1天一次,TTL:24H
)

func GetUserMicDayInvite(userId mysql.ID) string {
	date := time.Now().Format("2006-01-02")
	return redis_key.ReplaceKey(MicDayInvite, fmt.Sprintf("%d", userId), date)
}
