package medal_cv

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/cv/gift_cv"
	"hilo-group/domain/model/res_m"
	"sort"
)

type CvMedal struct {
	Id        uint32    `json:"id"`
	PicUrl    mysql.Str `json:"picUrl"`
	EffectUrl mysql.Str `json:"effectUrl"`
}

type ReturnGroupMedal struct {
	PicUrl  string `json:"picUrl"`
	SvgaUrl string `json:"svgaUrl"`
}

// 查询群流水勋章
func GetGroupConsumeMedal(model *domain.Model, groupId string) (uint64, *PicElement, error) {
	consumeTotal, err := gift_cv.GetGroupConsumeTotal(model, groupId)
	if err != nil {
		return 0, nil, err
	}
	rec, err := res_m.GetRoomMedalConfig(model.Db)
	if err != nil {
		return consumeTotal, nil, err
	}
	// 只显示最高等级的，所以要倒序遍历
	for i := len(rec) - 1; i >= 0; i-- {
		if consumeTotal >= rec[i].Threshold {
			return consumeTotal, &PicElement{PicUrl: rec[i].ActiveUrl}, nil
		}
	}
	return consumeTotal, nil, nil
}

type PicElement struct {
	PicUrl  string `json:"picUrl"`
	SvgaUrl string `json:"svgaUrl"`
}

func GetMedalInfoMap(db *gorm.DB, medals map[uint64][]uint32) (map[uint64][]uint32, map[uint64][]CvMedal, error) {
	resMedals, err := res_m.MedalGetAllMap(db)
	if err != nil {
		return nil, nil, err
	}

	medalIds := make(map[uint64][]uint32)
	medalMap := make(map[uint64][]CvMedal, 0)

	// 只选择合法的勋章
	for u, i := range medals {
		medalIds[u] = make([]uint32, 0)
		medalMap[u] = make([]CvMedal, 0)

		for _, j := range i {
			if e, ok := resMedals[j]; ok {
				medalIds[u] = append(medalIds[u], j)
				medalMap[u] = append(medalMap[u], CvMedal{
					Id:        j,
					PicUrl:    e.PicUrl,
					EffectUrl: e.SvgaUrl,
				})
			}
		}
		// 按照勋章排序
		sort.Slice(medalIds[u], func(i, j int) bool {
			return resMedals[medalIds[u][i]].Sort < resMedals[medalIds[u][j]].Sort
		})

		sort.Slice(medalMap[u], func(i, j int) bool {
			return resMedals[medalMap[u][i].Id].Sort < resMedals[medalMap[u][j].Id].Sort
		})
	}
	return medalIds, medalMap, nil
}
