ALTER TABLE hilo.group_power ADD nameplate varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' NOT NULL COMMENT '家族铭牌';
ALTER TABLE hilo.group_power ADD declaration varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' NOT NULL COMMENT '家族宣言';
ALTER TABLE hilo.group_power ADD icon varchar(200) DEFAULT 'https://image.whoisamy.shop/hilo/resource/family_default.png' NOT NULL COMMENT '家族头像';
CREATE INDEX nameplate_IDX USING BTREE ON hilo.group_power (nameplate);

CREATE TABLE `group_power_invite_join` (
                                           `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                           `user_id` bigint unsigned NOT NULL COMMENT '被邀请者id',
                                           `group_power_id` bigint unsigned NOT NULL,
                                           `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                           `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                           `invite_user_id` bigint unsigned NOT NULL COMMENT '邀请者id',
                                           `is_accept` tinyint NOT NULL DEFAULT '0' COMMENT '是否已经接受邀请',
                                           PRIMARY KEY (`id`),
                                           UNIQUE KEY `user_group` (`user_id`,`group_power_id`),
                                           KEY `group_power_id` (`group_power_id`),
                                           KEY `invite_user_id` (`invite_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='邀请加入家族';

CREATE TABLE `group_power_apply_join` (
                                          `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                          `user_id` bigint unsigned NOT NULL COMMENT '申请者id',
                                          `group_power_id` bigint unsigned NOT NULL,
                                          `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                          `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                          `is_accept` tinyint NOT NULL DEFAULT '0' COMMENT '是否已经接受',
                                          `mgr_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '审核的管理员id',
                                          PRIMARY KEY (`id`),
                                          KEY `group_power_id` (`group_power_id`),
                                          KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='申请加入家族';

CREATE TABLE `group_power_quit_log` (
                                        `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                        `user_id` bigint unsigned NOT NULL COMMENT '用户id',
                                        `mgr_id` bigint unsigned NOT NULL COMMENT '操作人id',
                                        `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                        `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                        `group_power_id` bigint unsigned NOT NULL,
                                        PRIMARY KEY (`id`),
                                        KEY `user_id` (`user_id`) USING BTREE,
                                        KEY `created_time` (`created_time`) USING BTREE,
                                        KEY `mgr_id` (`mgr_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO hilo.res_multi_text (msg_id, `language`, content)
VALUES (169, 'zh', '白银等级才可以修改'),
       (169, 'en', 'Can only be modified at the silver level'),
       (169, 'ar', 'لا يمكن تعديله إلا على المستوى الفضي'),
       (169, 'tr', 'Yalnızca gümüş seviyesinde değiştirilebilir'),
       (169, 'id', 'Hanya dapat dimodifikasi pada level perak'),
       (169, 'ru', 'Можно модифицировать только на серебряном уровне'),
       (169, 'ko', '실버 등급에서만 수정 가능'),
       (169, 'pt', 'Só pode ser modificado no nível prata'),
       (169, 'th', 'สามารถแก้ไขได้ที่ระดับซิลเวอร์เท่านั้น'),
       (169, 'ca', 'Solo se puede modificar en el nivel plata.'),
       (169, 'hi', 'केवल चांदी के स्तर पर संशोधित किया जा सकता है'),
       (169, 'vi', 'Chỉ có thể được sửa đổi ở cấp độ bạc'),
       (169, 'ur', 'صرف چاندی کی سطح پر نظر ثانی کی جا سکتی ہے');

INSERT INTO hilo.res_msg_translate (`language`, title, content, icon_url, msg_type, `type`, action_type, action_url)
VALUES ('zh', '', '你已加入家族，和朋友们一起快乐玩耍吧！', '', 1, 53, 0, ''),
       ('en', '', "You have joined the family, let's have fun with your friends!", '', 1, 53, 0, ''),
       ('ar', '', 'لقد انضممت إلى العائلة ، فلنستمتع مع أصدقائك!', '', 1, 53, 0, ''),
       ('tr', '', 'Aileye katıldınız, arkadaşlarınızla eğlenelim!', '', 1, 53, 0, ''),
       ('id', '', 'Anda telah bergabung dengan keluarga, mari bersenang-senang dengan teman-teman Anda!', '', 1, 53, 0,''),
       ('ru', '', 'Вы присоединились к семье, давайте веселиться с друзьями!', '', 1, 53, 0, ''),
       ('ko', '', '당신은 가족에 합류했습니다. 친구들과 즐거운 시간을 보내십시오!', '', 1, 53, 0, ''),
       ('pt', '', 'Você se juntou à família, vamos nos divertir com seus amigos!', '', 1, 53, 0, ''),
       ('th', '', 'คุณได้เข้าร่วมครอบครัวแล้ว มาสนุกกับเพื่อนๆ กันเถอะ!', '', 1, 53, 0, ''),
       ('ca', '', 'Te has unido a la familia, ¡diviértete con tus amigos!', '', 1, 53, 0, ''),
       ('hi', '', 'आप परिवार में शामिल हो गए हैं, आइए अपने दोस्तों के साथ मस्ती करें!', '', 1, 53, 0, ''),
       ('vi', '', 'Bạn đã tham gia gia đình, hãy vui vẻ với bạn bè của bạn!', '', 1, 53, 0, ''),
       ('ur', '', 'آپ خاندان میں شامل ہو گئے ہیں، آئیے اپنے دوستوں کے ساتھ مزے کریں!', '', 1, 53, 0, '');

INSERT INTO hilo.res_msg_translate (`language`, title, content, icon_url, msg_type, `type`, action_type, action_url)
VALUES ('zh', '', '有新朋友申请加入你的家族叻，请尽快审核。', '', 1, 54, 0, ''),
       ('en', '', 'There are new friends applying to join your family, please review as soon as possible.', '', 1, 54,0, ''),
       ('ar', '', 'هناك أصدقاء جدد يتقدمون للانضمام إلى عائلتك ، يرجى المراجعة في أقرب وقت ممكن.', '', 1, 54, 0, ''),
       ('tr', '', 'Ailenize katılmak için başvuran yeni arkadaşlar var, lütfen en kısa zamanda gözden geçirin.', '', 1,54, 0, ''),
       ('id', '', 'Ada teman baru yang melamar untuk bergabung dengan keluarga Anda, harap tinjau sesegera mungkin.','', 1, 54, 0, ''),
       ('ru', '', 'Есть новые друзья, подающие заявку на присоединение к вашей семье, пожалуйста, просмотрите их как можно скорее.', '', 1, 54, 0, ''),
       ('ko', '', '가족에 가입하려는 새로운 친구가 있습니다. 가능한 한 빨리 검토하십시오.', '', 1, 54, 0, ''),
       ('pt', '', 'Há novos amigos se inscrevendo para se juntar à sua família, revise o mais rápido possível.', '', 1, 54, 0, ''),
       ('th', '', 'มีเพื่อนใหม่สมัครเข้าร่วมครอบครัวของคุณ โปรดตรวจสอบโดยเร็วที่สุด', '', 1, 54, 0, ''),
       ('ca', '', 'Hay nuevos amigos que solicitan unirse a su familia, revíselos lo antes posible.', '', 1, 54, 0, ''),
       ('hi', '', 'आपके परिवार में शामिल होने के लिए नए मित्र आवेदन कर रहे हैं, कृपया जल्द से जल्द समीक्षा करें।', '', 1, 54, 0, ''),
       ('vi', '', 'Có những người bạn mới đăng ký tham gia gia đình của bạn, vui lòng xem xét càng sớm càng tốt.', '', 1, 54, 0, ''),
       ('ur', '', 'آپ کے خاندان میں شامل ہونے کے لیے نئے دوست درخواست دے رہے ہیں، براہ کرم جلد از جلد جائزہ لیں۔', '', 1, 54, 0, '');