CREATE TABLE `act_family_month_rank_log` (
                                 `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                 `period` varchar(20) NOT NULL DEFAULT '' COMMENT '月份',
                                 `family_id` bigint unsigned NOT NULL COMMENT '家族id',
                                 `rank_family` int unsigned NOT NULL DEFAULT '0' COMMENT '家族排名',
                                 `rank_user` int unsigned NOT NULL DEFAULT '0' COMMENT '用户在家族中的家族排名',
                                 `user_id` bigint unsigned NOT NULL COMMENT 'id',
                                 `award` varchar(500) NOT NULL DEFAULT '' COMMENT '获得的奖励',
                                 `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                 `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                 PRIMARY KEY (`id`),
                                 UNIQUE KEY `period` (`period`,`family_id`,`rank_user`),
                                 KEY `user_idx` (`user_id`) USING BTREE,
                                 KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='家族月度排行发奖日志';