package test

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/utils"
	"github.com/jinzhu/now"
	"hilo-group/domain/model/groupPower_m"
	"hilo-group/domain/model/group_m"
	"hilo-group/domain/service/group_power_s"
	"testing"
	"time"
)

func TestGetAllGroupPowerOwner(t *testing.T) {
	owners, _, err := groupPower_m.BatchGetAllGroupPowerUsers(domain.CreateModelNil(), 1, 1)
	println(owners, err)
}

func TestGetGroupPowerMonthStartTop1(t *testing.T) {
	res, err := groupPower_m.GetGroupPowerMonthStartTop1(domain.CreateModelNil(), 250)
	println(res, err)
}

func TestIsUseTRTC(t *testing.T) {
	if group_m.IsUseTRTC(domain.CreateModelNil(), "@TGS#3I57DMRIB") {
		fmt.Println("true--------------")
	}
}

func TestDoCalcGroupPowerMonthRankAct(t *testing.T) {
	lastDayTime := time.Now().AddDate(0, 0, -1)
	_now := now.New(lastDayTime)
	calcMonth := _now.BeginningOfMonth().Format(utils.MONTH_FORMAT)
	beginDate, endDate := _now.BeginningOfMonth().Format("2006-01-02"), _now.EndOfMonth().Format("2006-01-02")
	_ = group_power_s.DoCalcGroupPowerMonthRankAct(domain.CreateModelNil(), calcMonth, beginDate, endDate)
}
