package mgr_m

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/mgr_e"
	"hilo-group/myerr"
)

//投诉
type MgrReport struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	FromUserId    mysql.ID
	ToUserId      mysql.ID
	FromPageType  mgr_e.ReportPageType
	ReasonType    mgr_e.ReportReasonType
	OriginId      mysql.ID
	ImageUrl      mysql.Str
	Reason        mysql.Str
	Status        mgr_e.ReportStatus
	ReportDealId  mysql.ID
}

//投诉-群组
type MgrReportGroup struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	FromUserId    mysql.ID
	GroupId       mysql.Str
	ReasonType    mgr_e.ReportReasonType
	ImageUrl      mysql.Str
	Reason        mysql.Str
	Status        mgr_e.ReportStatus
	ReportDealId  mysql.ID
}

func ReportAdd(model *domain.Model, fromUserId mysql.ID, toUserId mysql.ID, fromPageType mgr_e.ReportPageType, originId mysql.ID, reasonType mgr_e.ReportReasonType, imageUrl mysql.Str, reason mysql.Str) *MgrReport {
	return &MgrReport{
		Model:        model,
		FromUserId:   fromUserId,
		ToUserId:     toUserId,
		FromPageType: fromPageType,
		ReasonType:   reasonType,
		OriginId:     originId,
		ImageUrl:     imageUrl,
		Reason:       reason,
		Status:       mgr_e.NoDealReportStatus,
	}
}

func ReportGroupAdd(model *domain.Model, fromUserId mysql.ID, groupId mysql.Str, reasonType mgr_e.ReportReasonType, imageUrl mysql.Str, reason mysql.Str) *MgrReportGroup {
	return &MgrReportGroup{
		Model:      model,
		FromUserId: fromUserId,
		GroupId:    groupId,
		ReasonType: reasonType,
		ImageUrl:   imageUrl,
		Reason:     reason,
		Status:     mgr_e.NoDealReportStatus,
	}
}

//检查投诉
func checkReport(model *domain.Model, reportId mysql.ID) (*MgrReport, error) {
	//var report = new(MgrReport)
	var report MgrReport
	if err := model.Db.First(&report, reportId).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, myerr.NewSysError("投诉不存在， Id：" + fmt.Sprintf("%d", reportId))
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	/*	if report.Status == mgr_m.HasDealReportStatus {
		return nil, myerr.NewSysError("投诉已被处理。， Id：" + mysql.IdToStr(reportId))
	}*/
	return &report, nil
}

//投诉处理
func ReportDeal(model *domain.Model, reportId mysql.ID) (*MgrReport, error) {
	report, err := checkReport(model, reportId)
	if err != nil {
		return nil, err
	}
	report.Status = mgr_e.HasDealReportStatus
	return report, nil
}

func GetMyReport(userId mysql.ID) ([]uint64, error) {
	users := make([]uint64, 0)
	report := make([]MgrReport, 0)
	if err := mysql.Db.Where("from_user_id = ?", userId).Find(&report).Error; err != nil && err != gorm.ErrRecordNotFound {
		return nil, myerr.WrapErr(err)
	}
	for _, i := range report {
		users = append(users, i.ToUserId)
	}
	return users, nil
}
