package gift_c

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"github.com/go-redis/redis/v8"
	"hilo-group/domain/event/gift_ev"
	"time"
)

const EventSendGiftHiloGroupQueue = "send:gift:queue:hilo_group"

// redis pop event sendGift
func BLPopQueueSendGift(model *domain.Model) *gift_ev.SendGiftEvent {
	var res *gift_ev.SendGiftEvent
	queue := EventSendGiftHiloGroupQueue
	strs, err := model.Redis.BLPop(model, time.Second, queue).Result()
	if err != nil {
		if err != redis.Nil {
			model.Log.Errorf("BLPopQueueSendGift fail:%v", err)
		}
		return nil
	}
	if len(strs) >= 2 {
		content := strs[1]
		res = new(gift_ev.SendGiftEvent)
		if err := json.Unmarshal([]byte(content), res); err != nil {
			model.Log.Errorf("BLPopQueueSendGift json fail:%v", err)
			return nil
		}
		return res
	}
	return nil
}
