package group_c

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"github.com/go-redis/redis/v8"
	"github.com/spf13/cast"
	"hilo-group/_const/redis_key/group_k"
	"strconv"
	"time"
)

// 用户进房
func ZAddUserEnterRoom(model *domain.Model, userId uint64, imGroupId string) {
	userKey := group_k.GetUserEnterRoomUserKey(userId)
	groupKey := group_k.GetUserEnterRoomGroupKey(imGroupId)
	if err := model.Redis.ZAdd(model, userKey, &redis.Z{
		Score:  float64(time.Now().Unix()),
		Member: imGroupId,
	}).Err(); err != nil {
		model.Log.Errorf("ZAddUserEnterRoom user fail:%v", err)
	}
	if err := model.Redis.ZAdd(model, groupKey, &redis.Z{
		Score:  float64(time.Now().Unix()),
		Member: userId,
	}).Err(); err != nil {
		model.Log.Errorf("ZAddUserEnterRoom room fail:%v", err)
	}
}

// 获取最近房间访客
// 15天
func GetLastRoomVisitors(model *domain.Model, imGroupId string) (userIds []uint64) {
	groupKey := group_k.GetUserEnterRoomGroupKey(imGroupId)
	res, err := model.Redis.ZRangeByScore(model, groupKey, &redis.ZRangeBy{
		Min: fmt.Sprintf("%d", time.Now().AddDate(0, 0, -15).Unix()),
		Max: "+inf",
	}).Result()
	if err != nil {
		return
	}
	for _, u := range res {
		uid, _ := strconv.ParseUint(u, 10, 64)
		if uid > 0 {
			userIds = append(userIds, uid)
		}
	}
	return
}

// 获取最近进入的房间
// 3个月
func GetUserRecentRooms(model *domain.Model, userId uint64, offset, limit int64) (imGroupIds []string, roomEnterTime map[string]int64) {
	roomEnterTime = make(map[string]int64)
	userKey := group_k.GetUserEnterRoomUserKey(userId)
	res, err := model.Redis.ZRangeByScoreWithScores(model, userKey, &redis.ZRangeBy{
		Min:    fmt.Sprintf("%d", time.Now().AddDate(0, -3, 0).Unix()),
		Max:    "+inf",
		Offset: offset,
		Count:  limit,
	}).Result()
	if err != nil {
		return
	}
	for _, v := range res {
		imGroupId := cast.ToString(v.Member)
		imGroupIds = append(imGroupIds, imGroupId)
		roomEnterTime[imGroupId] = int64(v.Score)
	}
	return
}

// 清理房间访客
// 15天前访问的
func RemoveRoomVisitors(model *domain.Model, imGroupId string) {
	groupKey := group_k.GetUserEnterRoomGroupKey(imGroupId)
	n, err := model.Redis.ZRemRangeByScore(model, groupKey, "-inf", fmt.Sprintf("%d", time.Now().AddDate(0, 0, -15).Unix())).Result()
	if err != nil {
		model.Log.Errorf("RemoveRoomVisitors fail:%v", err)
	} else {
		model.Log.Infof("RemoveRoomVisitors key:%v,n:%v", groupKey, n)
	}
}
