package luckyWheel_m

import (
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
)

type LuckyWheelUserOption struct {
	UserId      uint64
	GroupId     string
	LastId      uint
	SelfJoin    bool
	AutoRestart bool
}

func (uo *LuckyWheelUserOption) Save(db *gorm.DB) error {
	return db.Clauses(clause.OnConflict{
		DoUpdates: clause.AssignmentColumns([]string{"last_id", "self_join", "auto_restart"}),
	}).Create(uo).Error
}