package user_cv

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/domain/model/user_m"
)

// 批量获取财富等级
func BatchGetWealthGrade(userIds []mysql.ID) (map[mysql.ID]uint32, error) {
	rows := make([]user_m.MatchWealthUserScore, 0)
	err := mysql.Db.Model(&user_m.MatchWealthUserScore{}).Where("user_id IN ?", userIds).Find(&rows).Error
	if err == nil {
		result := make(map[mysql.ID]uint32, 0)
		for _, i := range rows {
			result[i.UserId] = i.Grade
		}
		return result, nil
	} else {
		return nil, err
	}
}

// 批量获取魅力等级
func BatchGetCharmGrade(userIds []mysql.ID) (map[mysql.ID]uint32, error) {
	rows := make([]user_m.MatchCharmUserScore, 0)
	err := mysql.Db.Model(&user_m.MatchCharmUserScore{}).Where("user_id IN ?", userIds).Find(&rows).Error
	if err == nil {
		result := make(map[mysql.ID]uint32, 0)
		for _, i := range rows {
			result[i.UserId] = i.Grade
		}
		return result, nil
	} else {
		return nil, err
	}
}

// 批量获取活跃等级
func BatchGetActiveGrade(userIds []mysql.ID) (map[mysql.ID]uint32, error) {
	rows := make([]user_m.MatchActityUserScore, 0)
	err := mysql.Db.Model(&user_m.MatchActityUserScore{}).Where("user_id IN ?", userIds).Find(&rows).Error
	if err == nil {
		result := make(map[mysql.ID]uint32, 0)
		for _, i := range rows {
			result[i.UserId] = i.Grade
		}
		return result, nil
	} else {
		return nil, err
	}
}
