package charge_r

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"github.com/gin-gonic/gin"
	"hilo-group/domain/cache/user_c"
	"hilo-group/domain/service/diamond_s"
	"hilo-group/req"
	"hilo-group/resp"
)

// @Tags 充值
// @Summary 是否可以分享充值链接
// @Param externalId query string true "分享对象的external id"
// @Success 200
// @Router /v1/charge/share [get]
func CanShareChargeLink(c *gin.Context) (*mycontext.MyContext, error) {
	myContext := mycontext.CreateMyContext(c.Keys)

	userId, lang, err := req.GetUserIdLang(c, myContext)
	if err != nil {
		return myContext, err
	}

	extId := c.Query("externalId")
	model := domain.CreateModelContext(myContext)
	toUser, err := user_c.GetUserByExternalId(model, extId)
	if err != nil {
		return myContext, err
	}

	// 家族限制检查
	if err = diamond_s.NewDiamondService(myContext).CheckDealerTransferFamilyLimit(userId, toUser.ID, lang); err != nil {
		myContext.Log.Errorf("CanShareChargeLink err:%v", err)
		return myContext, err
	}

	resp.ResponseOk(c, nil)
	return myContext, nil
}
