package gift_cron

import (
	"context"
	"git.hilo.cn/hilo-common/_const/rediskey"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/resource/redisCli"
	"hilo-group/_const/enum/gift_e"
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/domain/cache/gift_c"
	"hilo-group/domain/cache/groupPower_c"
	"hilo-group/domain/event/gift_ev"
	"hilo-group/domain/model/groupPower_m"
	"hilo-group/domain/model/group_m"
	"time"
)

// 送礼事件
func SendGiftEvent() {
	//if !config.IsMaster() {
	//	return
	//}
	go func() {
		for true {
			model := domain.CreateModelNil()
			if sendGiftEvent := gift_c.BLPopQueueSendGift(model); sendGiftEvent != nil {
				groupPowerGrade(model, sendGiftEvent)        // 家族经验
				groupPowerStar(model, sendGiftEvent)         // 家族之星
				groupSupportAddConsume(model, sendGiftEvent) // 群组扶持
			}
		}
	}()
}

// 群组势力经验
func groupPowerGrade(model *domain.Model, sendGiftEvent *gift_ev.SendGiftEvent) {
	model.Log.Infof("AddSendGiftEventAsync %+v", sendGiftEvent)
	if sendGiftEvent.ResGift.GiftType != mysql.DiamondYellow {
		return
	}
	exist, groupPowerId, err := groupPower_m.CheckGroupPowerUser(model, sendGiftEvent.SendUserId)
	if err != nil {
		model.Log.Infof("CheckGroupPowerUser fail %+v", err)
		return
	}
	if exist {
		exp := sendGiftEvent.GiftN * mysql.Num(len(sendGiftEvent.ReceiveUserIds)) * sendGiftEvent.ResGift.DiamondNum
		//return model.Transaction(func(model *domain.Model) error {
		//	return groupPower_m.IncrGroupPowerExp(model, groupPowerId, exp, sendGiftEvent.SendUserId, "送礼")
		//})
		//return groupPower_c.QueueGroupPowerGradeExp(model, groupPowerId, exp, sendGiftEvent.SendUserId, "送礼")
		if err := model.Transaction(func(model *domain.Model) error {
			return groupPower_m.IncrGroupPowerExp(model, groupPowerId, exp, sendGiftEvent.SendUserId, "送礼")
		}); err != nil {
			model.Log.Errorf("IncrGroupPowerExp fail,data:%v-err:%v", *sendGiftEvent, err)
		} else {
			model.Log.Infof("IncrGroupPowerExp success,data:%v", *sendGiftEvent)
		}
	}
}

// 家族之星
func groupPowerStar(model *domain.Model, sendGiftEvent *gift_ev.SendGiftEvent) {
	if sendGiftEvent.ResGift.GiftType != mysql.DiamondYellow {
		return
	}
	var userIds = []mysql.ID{sendGiftEvent.SendUserId}
	userIds = append(userIds, sendGiftEvent.ReceiveUserIds...)
	groupPowers, err := groupPower_m.BatchGetGroupPowerUser(model, userIds)
	if err != nil {
		model.Log.Errorf("AddSendGiftEventAsync fail:%v", err)
		return
	}
	// 送礼加分
	if data, ok := groupPowers[sendGiftEvent.SendUserId]; ok {
		diamonds := sendGiftEvent.GiftN * sendGiftEvent.ResGift.DiamondNum * mysql.Num(len(sendGiftEvent.ReceiveUserIds))
		if err := groupPower_c.IncrGroupPowerDayStarScore(model, data.GroupPowerId, data.UserId,
			groupPower_e.GroupPowerStarTypeFamous, diamonds); err != nil {
			model.Log.Errorf("IncrGroupPowerDayStarScore famous fail:%v", err)
		}
	}
	// 收礼加分
	for _, userId := range sendGiftEvent.ReceiveUserIds {
		if data, ok := groupPowers[userId]; ok {
			diamonds := sendGiftEvent.GiftN * sendGiftEvent.ResGift.DiamondNum
			if err := groupPower_c.IncrGroupPowerDayStarScore(model, data.GroupPowerId, data.UserId,
				groupPower_e.GroupPowerStarTypeCharm, diamonds); err != nil {
				model.Log.Errorf("IncrGroupPowerDayStarScore charm fail:%v", err)
			}
		}
	}
	return
}

// 群组扶持增加流水数据
func groupSupportAddConsume(model *domain.Model, sendGiftEvent *gift_ev.SendGiftEvent) {
	if time.Now().Unix() <= 1692843600 {
		return
	}
	model.Log.Infof("groupSupportAddConsume UserId:%d, sendGiftEvent:%+v", sendGiftEvent.SendUserId, sendGiftEvent)
	if sendGiftEvent.SceneType != gift_e.GroupSceneType || sendGiftEvent.SceneUid == "" {
		model.Log.Infof("groupSupportAddConsume UserId:%d, sendGiftEvent:%+v", sendGiftEvent.SendUserId, sendGiftEvent)
		return
	}
	_, _, period := group_m.GetSupportLevelTime(time.Now())
	// 钻石数
	diamond := sendGiftEvent.GiftN * sendGiftEvent.ResGift.DiamondNum * mysql.Num(len(sendGiftEvent.ReceiveUserIds))
	keyDiamond := rediskey.GetGroupSupportConsumeSummary(period)
	_, err := model.RedisCluster.ZIncrBy(context.Background(), keyDiamond, float64(diamond), sendGiftEvent.SceneUid).Result()
	if err != nil {
		model.Log.Errorf("groupSupportAddConsume key:%s, val:%d, member:%s, err:%v",
			keyDiamond, diamond, sendGiftEvent.SceneUid, err)
	}
	err = redisCli.SetExpire(model.RedisCluster, keyDiamond, time.Hour*24*14) // 保留两周
	if err != nil {
		model.Log.Errorf("groupSupportAddConsume key:%s, val:%d, member:%s, err:%v",
			keyDiamond, diamond, sendGiftEvent.SceneUid, err)
	}
	// 支持者数量
	keySupportNum := rediskey.GetGroupSupportCountSupporter(period, sendGiftEvent.SceneUid)
	err = model.RedisCluster.SAdd(context.Background(), keySupportNum, sendGiftEvent.SendUserId).Err()
	if err != nil {
		model.Log.Errorf("groupSupportAddConsume key:%s, UserId:%d, err:%v", keySupportNum, sendGiftEvent.SendUserId, err)
	}
	err = redisCli.SetExpire(model.RedisCluster, keySupportNum, time.Hour*24*14) // 保留两周
	if err != nil {
		model.Log.Errorf("groupSupportAddConsume key:%s, UserId:%d, err:%v", keySupportNum, sendGiftEvent.SendUserId, err)
	}
	return
}
