package group_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"github.com/robfig/cron"
	"hilo-group/domain/service/group_s"
)

// 清理家族经验和等级
func GroupCountryListSort() {

	// 常用国家-每15分钟计算国家房间列表排序 /v1/imGroup/country [get] 接口
	spec := "0 */15 * * * ?"
	c := cron.New()
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		model.Log.Infof("GroupCountryListSort Common start")
		group_s.SortGroupCommonCountryList(model)
		model.Log.Infof("GroupCountryListSort Common end")
	})

	// 非常用国家-每60分钟计算国家房间列表排序 /v1/imGroup/country [get] 接口
	spec2 := "0 46 * * * ?"
	_ = c.AddFunc(spec2, func() {
		var model = domain.CreateModelNil()
		model.Log.Infof("GroupCountryListSort not Common start")
		group_s.SortGroupNotCommonCountryList(model)
		model.Log.Infof("GroupCountryListSort not Common end")
	})

	c.Start()
}
