package group_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"github.com/robfig/cron"
	"hilo-group/domain/service/group_power_s"
)

// 家族贡献月度排行榜发奖
func GroupPowerMonthRankAct() {
	if !config.IsMaster() {
		return
	}
	c := cron.New()
	// 每月1号0:01结算发奖
	spec := "0 1 0 1 * ?"
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		if err := group_power_s.CalcGroupPowerMonthRankAct(model); err != nil {
			model.Log.Errorf("GroupPowerMonthRankAct fail:%v", err)
		}
	})

	c.Start()
}

//func BufaGroupPowerMonthRankAct() {
//	c := cron.New()
//	spec := "0 50 15 1 * ?"
//	_ = c.AddFunc(spec, func() {
//		var model = domain.CreateModelNil()
//		if err := group_power_s.BufaCalcGroupPowerMonthRankAct(model); err != nil {
//			model.Log.Errorf("BufaGroupPowerMonthRankAct fail:%v", err)
//		}
//	})
//
//	c.Start()
//}
