package group_cron

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"git.hilo.cn/hilo-common/sdk/tencentyun"
	"git.hilo.cn/hilo-common/utils"
	"github.com/robfig/cron"
	"hilo-group/_const/enum/group_e"
	"hilo-group/domain/model/group_m"
	"hilo-group/domain/service/group_s"
	"time"
)

// 群组扶持计算
func CalcGroupSupport() {
	if !config.IsMaster() {
		return
	}
	c := cron.New()
	//北京时间周一0点，过了一秒后，
	spec := "1 0 0 * * 1"
	_ = c.AddFunc(spec, func() {
		defer utils.CheckGoPanic()
		var model = domain.CreateModelNil()
		//开始
		model.Log.Infof("cron CalcGroupSupport start")

		calcTime := time.Now().AddDate(0, 0, -1)
		if err := group_s.NewGroupService(model.MyContext).GroupSupportResult(calcTime); err != nil {
			model.Log.Errorf("cron CalcGroupSupport faild calcTime:%v, err:%v", calcTime, err)
			return
		}
		model.Log.Infof("cron CalcGroupSupport after GroupSupportResult")

		//全服发送H5
		if err := sendGroupSupportH5(domain.CreateModelContext(model.MyContext)); err != nil {
			model.Log.Errorf("cron CalcGroupSupport err:%v", err)
		} else {
			model.Log.Infof("cron CalcGroupSupport success")
		}
	})

	c.Start()
}

func sendGroupSupportH5(model *domain.Model) error {
	groupIds, err := group_m.GetAllGroupsSorted(model)
	if err != nil {
		return err
	}

	model.Log.Infof("SendGroupSupportH5 groupIds:%v", groupIds)

	groupSupportH5 := group_m.GroupSupportH5{
		CommonPublicMsg: group_m.CommonPublicMsg{
			Type: group_e.GroupSupportH5,
		},
		H5: config.GetH5Config().GROUP_SUPPORT,
	}
	buffer, err := json.Marshal(groupSupportH5)
	if err != nil {
		model.Log.Errorf("publicScreenMsg AddSendGiftAsync json.Marshal(giftContent) err:%v", err)
		return err
	}
	content := string(buffer)

	//策略1：for循环，没有开启协程，100个停一下
	for i, _ := range groupIds {
		func(groupId string, content string) {
			defer utils.CheckGoPanic()
			model.Log.Infof("SendGroupSupportH5 groupId:%v", groupId)
			txGroupId, err := group_m.ToTxGroupId(model, groupId)
			// 公屏消息
			if err == nil {
				tencentyun.SendCustomMsg(model.Log, txGroupId, nil, content, "")
			}
		}(groupIds[i], content)

		if i != 0 && i%100 == 0 {
			//躺平1秒
			time.Sleep(1 * time.Second)
		}
	}
	return nil
}

// 群组扶持计算-旧数据
//func CalcGroupSupport_OldData() {
//	if !config.IsMaster() {
//		return
//	}
//	c := cron.New()
//	spec := "0 20 11 25 8 ?"
//	_ = c.AddFunc(spec, func() {
//		defer utils.CheckGoPanic()
//		var model = domain.CreateModelNil()
//		//开始
//		model.Log.Infof("CalcGroupSupport_OldData start")
//
//		beginTime, endTime, period := group_m.GetSupportLevelTime(time.Now().AddDate(0, 0, -group_e.SUPPORT_LEVEL_PERIOD_DAY))
//		//beginTime, _, period := group_m.GetSupportLevelTime(time.Now())
//		//endTime := time.Unix(1692843600, 0)
//
//		g := gift_m.GiftOperate{SceneType: gift_e.GroupSceneType, Model: model}
//		records, err := g.BatchGetConsumeByRange(beginTime, endTime)
//		if err != nil {
//			model.Log.Errorf("CalcGroupSupport_OldData beginTime:%v, endTime:%v, err:%v", beginTime, endTime, err)
//			return
//		}
//		// 流水写入redis
//		keyDiamond := rediskey.GetGroupSupportConsumeSummary(period)
//		for _, r := range records {
//			if r.SceneUid == "" || r.Consume <= 0 {
//				continue
//			}
//			_, err = model.RedisCluster.ZIncrBy(context.Background(), keyDiamond, float64(r.Consume), r.SceneUid).Result()
//			if err != nil {
//				model.Log.Errorf("CalcGroupSupport_OldData groupSupport key:%s, val:%d, member:%s, err:%v",
//					keyDiamond, r.Consume, r.SceneUid, err)
//			}
//		}
//		err = redisCli.SetExpire(model.RedisCluster, keyDiamond, time.Hour*24*14) // 保留两周
//		if err != nil {
//			model.Log.Errorf("CalcGroupSupport_OldData groupSupport key:%s, err:%v", keyDiamond, err)
//			return
//		}
//		// 支持者写入redis
//		for _, r := range records {
//			if r.SceneUid == "" || r.C <= 0 {
//				continue
//			}
//			// 支持者列表
//			support := gift_m.GiftOperate{SceneType: gift_e.GroupSceneType, SceneUid: r.SceneUid, Model: model}
//			uids, err := support.BatchGetSupportList(beginTime, endTime)
//			if err != nil {
//				model.Log.Errorf("CalcGroupSupport_OldData beginTime:%v, endTime:%v, imGroupId:%v, err:%v", beginTime, endTime, r.SceneUid, err)
//				continue
//			}
//			if len(uids) <= 0 {
//				continue
//			}
//			// 支持者数量
//			keySupportNum := rediskey.GetGroupSupportCountSupporter(period, r.SceneUid)
//			for _, uid := range uids {
//				err = model.RedisCluster.SAdd(context.Background(), keySupportNum, uid).Err()
//				if err != nil {
//					model.Log.Errorf("CalcGroupSupport_OldData groupSupport key:%s, UserId:%d, err:%v", keySupportNum, uid, err)
//				}
//			}
//			err = redisCli.SetExpire(model.RedisCluster, keySupportNum, time.Hour*24*14) // 保留两周
//			if err != nil {
//				model.Log.Errorf("AddSendGiftEventAsync groupSupport key:%s, err:%v", keySupportNum, err)
//			}
//		}
//
//		model.Log.Infof("CalcGroupSupport_OldData end")
//	})
//
//	c.Start()
//}
