package mic_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"github.com/robfig/cron"
	"hilo-group/domain/cache/mic_c"
	"hilo-group/domain/event/mic_ev"
	"hilo-group/domain/model/group_m"
	"hilo-group/domain/model/mic_m"
	"hilo-group/domain/service/group_mic_s"
	"time"
)

func OnMicCheck() {
	c := cron.New()
	//一分钟执行一次
	spec := "30 */1 * * * ?"
	_ = c.AddFunc(spec, func() {
		//获取麦上的所有人
		var model = domain.CreateModelNil()
		groupIds, err := group_m.GetMicHasInGroups()
		if err != nil {
			model.Log.Errorf("cron micIn GetMicHasInGroups err:%v", err)
			return
		}
		for _, groupId := range groupIds {
			//遍历每个麦位
			for i := 1; i <= group_m.MaxMicNum; i++ {
				micUser, err := group_m.GetMicUser(model, groupId, i)
				if err != nil {
					model.Log.Errorf("cron micIn group_m.GetMicUser err:%v", err)
				}
				if micUser != nil {
					if err := mic_c.QueueOnMic(model, &mic_ev.OnMicEvent{
						GroupUuid:  micUser.GroupUuid,
						I:          micUser.I,
						ExternalId: micUser.ExternalId,
						UserId:     micUser.UserId,
						Forbid:     micUser.Forbid,
						Timestamp:  micUser.Timestamp,
					}); err != nil {
						model.Log.Errorf("QueueOnMic fail:%v", err)
					}
				}
			}
		}
	})
	c.Start()
}

func OnMicQueue() {
	for i := 0; i < 4; i++ {
		go func() {
			for true {
				model := domain.CreateModelNil()
				if onMic := mic_c.BLPopQueueOnMic(model); onMic != nil {
					start := time.Now()
					// 群组上麦经验
					if err := group_mic_s.NewGroupPowerService(model.MyContext).IncrGroupPowerOnMicExpAndTime(onMic.GroupUuid, onMic.UserId, onMic.Timestamp); err != nil {
						model.Log.Errorf("cron micIn GroupPowerOnMicExp err:%v", err)
					} else {
						model.Log.Infof("cron micIn GroupPowerOnMicExp success, groupId:%v, userId:%v,cost:%vs", onMic.GroupUuid, onMic.UserId, time.Now().Sub(start).Seconds())
					}

					// 用户上麦
					//if err := mic_m.IncrUserOnMic(model, onMic.UserId, onMic.Timestamp); err != nil {
					//if err := mic_m.IncrUserOnMicV2(model, onMic.UserId); err != nil {
					if err := mic_m.IncrUserOnMicV3(model, onMic.UserId); err != nil {
						model.Log.Errorf("cron micIn IncrUserOnMic err:%v", err)
					} else {
					}
				}
			}
		}()
	}
}
