package group_power_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

//注册监听
var groupPowerJoinListen = new(domain.EventBase)

type GroupPowerJoinEvent struct {
	UserId       mysql.ID
	GroupPowerId mysql.ID
}

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupPowerJoinSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupPowerJoinListen, callback)
}

//加入到异步操作中
func AddGroupPowerJoinAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupPowerJoinListen, callback)
}

//领域事件发布
func PublishGroupPowerJoin(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(groupPowerJoinListen, model, event)
}
