package event_s

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/rpc"
	"hilo-group/domain/event/group_ev"
	"hilo-group/domain/model/group_m"
	"hilo-group/myerr/bizerr"
)

// 用户进房后推送mic信息
func GroupInMicChangeEvent() {
	group_ev.AddTxGroupInEventAsync(func(model *domain.Model, event interface{}) error {
		e, ok := event.(*group_ev.TxGroupInEvent)
		if !ok {
			return bizerr.InvalidParameter
		}
		return MicAllRPush(model, e.GroupId, e.UserId, e.ExternalId)
	})
}

func MicAllRPush(model *domain.Model, txGroupUid string, userId uint64, externalId string) error {
	model.Log.Infof("MicChangeRPush MicAllRPush begin groupUuid:%v, externalId:%v", txGroupUid, externalId)

	imGroupId, err := group_m.ToImGroupId(model, txGroupUid)
	if err != nil {
		model.Log.Errorf("ToImGroupId fail:%v", err)
		return err
	}
	//
	micContents, err := group_m.GetMicAllContent(model, imGroupId)
	if err != nil {
		model.Log.Errorf("MicChangeRPush MicAllRPush getMicAllContent  err:%+v, micContents:%v groupUuid:%v, externalId:%v", err, micContents, txGroupUid, externalId)
		return err
	}
	for _, micContent := range micContents {
		//麦上是默认值，就不用推
		if micContent.Forbid == false && micContent.User == nil && micContent.AgoraId == 0 && micContent.Lock == false && micContent.ExternalId == "" && micContent.MicForbid == false {
			model.Log.Infof("MicChangeRPush MicAllRPush default micContent:%v, groupUuid:%v, externalId:%v, micContent:%+v", micContent, txGroupUid, externalId, micContent)
			continue
		}
		micContentStr, err := json.Marshal(micContent)
		if err != nil {
			continue
		}
		tmpMicUser := new(group_m.MicUserData)
		if micContent.User != nil {
			tmpMicUser = micContent.User
		}
		if err := rpc.SendSocketMicChange(userId, externalId, txGroupUid, uint32(micContent.I), micContent.Lock, micContent.Forbid, micContent.MicForbid, micContent.AgoraId,
			tmpMicUser.Id, tmpMicUser.ExternalId, tmpMicUser.Avatar, tmpMicUser.Nick, uint32(tmpMicUser.Sex), tmpMicUser.Code, tmpMicUser.IsVip, uint32(tmpMicUser.NobleLeave),
			tmpMicUser.HeadwearPicUrl, tmpMicUser.HeadwearEffectUrl, tmpMicUser.HeadwearReverseEffectUrl, uint32(tmpMicUser.SvipLevel), tmpMicUser.MicEffect, tmpMicUser.HeadwearIcon); err != nil {
			model.Log.Errorf("MicAllRPush err:%+v, groupUuid:%v, externalId:%v, micContent:%+v", err, txGroupUid, externalId, string(micContentStr))
		} else {
			model.Log.Infof("MicChangeRPush MicAllRPush Marshal micContent, groupUuid:%v, externalId:%v, micContent:%+v", txGroupUid, externalId, string(micContentStr))
		}
	}
	model.Log.Infof("MicAllRPush end groupUuid:%v, externalId:%v", txGroupUid, externalId)
	return nil
}
