package diamond_cv

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	. "git.hilo.cn/hilo-common/utils"
	"hilo-group/domain/model/diamond_m"
)

type CvDiamond struct {
	//钻石数量
	DiamondNum *uint32 `json:"diamondNum"`
	//粉钻数量
	PinkDiamondNum *uint32 `json:"pinkDiamondNum"`
}

type CvDiamondBean struct {
	//钻石数量
	DiamondNum uint32 `json:"diamondNum"`
	//豆子数量
	BeanNum string `json:"beanNum"`
}


type CvDiamondDetail struct {
	//1：增加 2：减少
	AddReduce *uint8 `json:"addReduce"`
	//6：注册 3：建立融云会话 4：购买钻石 1：发送礼物 5：接受礼物 2：匹配条件
	OperateType *uint8 `json:"operateType"`
	//钻石的数量
	DiamondNum *uint32 `json:"diamondNum"`
	//创建时间
	CreatedTime *int64 `json:"createdTime"`
}

func GetDiamond(userId mysql.ID) (*CvDiamond, error) {
	var diamondAccount diamond_m.DiamondAccount
	err := mysql.Db.Where(&diamond_m.DiamondAccount{
		UserId: userId,
	}).First(&diamondAccount).Error
	if err != nil {
		return nil, err
	}
	return &CvDiamond{DiamondNum: NumToUint32(&diamondAccount.DiamondNum), PinkDiamondNum: NumToUint32(&diamondAccount.PinkDiamondNum)}, nil
}