package bizerr

import (
	"hilo-group/myerr"
)

var (
	// 一般性错误
	TokenInvalid         = myerr.NewBusinessCode(1001, "token invalid", myerr.BusinessData{})
	ExternalIdNoExist    = myerr.NewBusinessCode(1003, "externalId no exist", myerr.BusinessData{})
	CodeNoExist          = myerr.NewBusinessCode(1005, "code no exist", myerr.BusinessData{})
	ParaMissing          = myerr.NewBusinessCode(1006, "parameter missing", myerr.BusinessData{})
	EmptyContent         = myerr.NewBusinessCode(1007, "Content is empty", myerr.BusinessData{})
	ContentTooLong       = myerr.NewBusinessCode(1008, "Content is too long", myerr.BusinessData{})
	InvalidParameter     = myerr.NewBusinessCode(1009, "Invalid parameter", myerr.BusinessData{})
	NotQualified         = myerr.NewBusinessCode(1010, "Not qualified", myerr.BusinessData{})
	IncorrectState       = myerr.NewBusinessCode(1013, "Incorrect state", myerr.BusinessData{})
	UpgradeRequired      = myerr.NewBusinessCode(1015, "Version too old. Upgrade is required", myerr.BusinessData{})
	TransactionFailed    = myerr.NewBusinessCode(1014, "Transaction failed", myerr.BusinessData{})
	ImagePolicyViolation = myerr.NewBusinessCode(1017, "image policy violation", myerr.BusinessData{})
	ReqTooFrequent       = myerr.NewBusinessCode(1018, "Requests are too frequent", myerr.BusinessData{})

	// 钻石
	DiamondNoEnough      = myerr.NewBusinessCode(4000, "Insufficient diamonds", myerr.BusinessData{})
	DiamondFrequency     = myerr.NewBusinessCode(4001, "Diamond operation frequency too high", myerr.BusinessData{})
	DiamondAccountFrozen = myerr.NewBusinessCode(4004, "Diamond Account Frozen", myerr.BusinessData{})

	// 礼物
	ResGiftNoUser           = myerr.NewBusinessCode(5001, "GiftDetail is gone", myerr.BusinessData{})   // 礼物已经下架
	ResHeadwearDiamondNoUse = myerr.NewBusinessCode(5003, "Headwear can not buy", myerr.BusinessData{}) //头饰不能买
	ResPropertyDiamondNoUse = myerr.NewBusinessCode(5004, "Property can not buy", myerr.BusinessData{}) //头饰不能买

	UserMedalThresholdLimit      = myerr.NewBusinessCode(9006, "勋章条件未达到", myerr.BusinessData{})
	UserGlobalBroadcastManagerNo = myerr.NewBusinessCode(9008, "不是全球广播管理人", myerr.BusinessData{})
	UserHeadwearHasEnd           = myerr.NewBusinessCode(9014, "用户头饰已经过期， 不能赠送", myerr.BusinessData{})
	UserPropertyHasEnd           = myerr.NewBusinessCode(9015, "用户座驾已经过期， 不能赠送", myerr.BusinessData{})
	EditCd                       = myerr.NewBusinessCode(9017, "not allow to edit", myerr.BusinessData{}) // 编辑cd中

	// 麦位
	GroupMicNoPermission   = myerr.NewBusinessCode(12000, "Mic has no permission to mic", myerr.BusinessData{})                      // 麦位没有操作的权限
	GroupMicNoUser         = myerr.NewBusinessCode(12002, "No one on Mic", myerr.BusinessData{})                                     // 麦位上没有人
	GroupMicLock           = myerr.NewBusinessCode(12003, "Mic is locked", myerr.BusinessData{})                                     // 麦位加锁了
	GroupMicHasUser        = myerr.NewBusinessCode(12004, "Mic occupied", myerr.BusinessData{})                                      // 麦位中已经有人了
	GroupConcurrencyLock   = myerr.NewBusinessCode(12005, "concurrent Mic operation, please try ageain later", myerr.BusinessData{}) // 麦位并发操作，请重试
	GroupMicUserHasIn      = myerr.NewBusinessCode(12006, "Already on Mic", myerr.BusinessData{})                                    // 你已经在别的麦位上了
	GroupMicNoYou          = myerr.NewBusinessCode(12007, "Not on Mic", myerr.BusinessData{})                                        // 你不在该麦位上
	GroupMicInByInviteFail = myerr.NewBusinessCode(12008, "从邀请中上麦失败", myerr.BusinessData{})
	GroupInfoMicClosed     = myerr.NewBusinessCode(12009, "The Group does not open the mic positions", myerr.BusinessData{})
	GroupMicBanTourist     = myerr.NewBusinessCode(12010, "Mic need member", myerr.BusinessData{}) // 游客不能上麦

	// 群组
	GroupNotFound            = myerr.NewBusinessCode(14001, "Group not found", myerr.BusinessData{})                                                                // 找不到该群
	NotGroupMember           = myerr.NewBusinessCode(14002, "Not a group member", myerr.BusinessData{})                                                             // 不是群成员
	IncorrectPassword        = myerr.NewBusinessCode(14003, "Incorrect password", myerr.BusinessData{})                                                             // 密码错
	NoPrivileges             = myerr.NewBusinessCode(14004, "Not enough permission", myerr.BusinessData{})                                                          // 操作权限不够
	InBlacklist              = myerr.NewBusinessCode(14005, "Can not join the group due to blacklist", myerr.BusinessData{})                                        // 在群黑名单中，不能进群
	GroupInKick              = myerr.NewBusinessCode(14007, "Kicked, can not join the group. Try again later", myerr.BusinessData{})                                // 在被踢出的有效期中
	OwnerCannotLeave         = myerr.NewBusinessCode(14008, "Owner can not leave the group", myerr.BusinessData{})                                                  // 群主不能退群
	WrongPasswordLength      = myerr.NewBusinessCode(14010, "Incorrect password length", myerr.BusinessData{})                                                      // 密码长度错误
	GroupIsBanned            = myerr.NewBusinessCode(14011, "group is banned by ", myerr.BusinessData{})                                                            // 群已经被管理员封禁
	GroupLimitReached        = myerr.NewBusinessCode(14012, "Join group limit reached", myerr.BusinessData{})                                                       // 所在群已达上限
	RoleLimitReached         = myerr.NewBusinessCode(14013, "Role limit reached", myerr.BusinessData{})                                                             // 所任角色已达上限
	GroupCreateLimitReached  = myerr.NewBusinessCode(14014, "Create group limit reached", myerr.BusinessData{})                                                     // 你创建的群组数已达上限
	GroupLimitReachedVip     = myerr.NewBusinessCode(14015, "Join group limit reached. Please purchase VIP", myerr.BusinessData{})                                  // 所在群已达上限，请购买VIP
	GroupAlreadyAwarded      = myerr.NewBusinessCode(14016, "Group support awarded", myerr.BusinessData{})                                                          // 群支持奖励已经发放过了
	NotManagerOrAdmin        = myerr.NewBusinessCode(14017, "Not manager or group admin", myerr.BusinessData{})                                                     // 不是经理或管理员
	UserAlreadyAwarded       = myerr.NewBusinessCode(14018, "User already awarded", myerr.BusinessData{})                                                           // 用户的群支持奖励已经发放过了
	ImeiAlreadyAwarded       = myerr.NewBusinessCode(14019, "Imei support awarded", myerr.BusinessData{})                                                           // 设备的群支持奖励已经发放过了
	GroupCustomThemeLimit    = myerr.NewBusinessCode(14020, "Group Custom Theme Limit", myerr.BusinessData{})                                                       //群主题定制数量只能是5个
	GroupSupportIpLimit      = myerr.NewBusinessCode(14024, "ID:%v is a duplicate account, please select another user to receive the reward", myerr.BusinessData{}) // 群组扶持ip限制
	GroupNoPowerToSvip6      = myerr.NewBusinessCode(14026, "Cannot use this permission for SVIP6", myerr.BusinessData{})                                           // 踢出,无法对SVIP6使用此权限
	GroupSupportWealthLevel3 = myerr.NewBusinessCode(14027, "Wealth level not reach 3", myerr.BusinessData{})                                                       // 财富等级3级

	// 家族
	GroupPowerHasJoinOther      = myerr.NewBusinessCode(15001, "You already have joined power, please exit first", myerr.BusinessData{})              // 已经加入了其它国家势力
	GroupPowerHasJoinMy         = myerr.NewBusinessCode(15002, "You already have joined power, please exit first", myerr.BusinessData{})              // 已经加入了该国家势力
	GroupPowerOwnerLeave        = myerr.NewBusinessCode(15003, "power owner cannot exit", myerr.BusinessData{})                                       // 势力主不能退出
	GroupPowerNotExist          = myerr.NewBusinessCode(15004, "国家势力不存在", myerr.BusinessData{})                                                       // 国家势力不存在
	GroupPowerNoOwner           = myerr.NewBusinessCode(15005, "power owner not exits or unique", myerr.BusinessData{})                               // 国家势力主不存在或不唯一
	GroupPowerStayTooShort      = myerr.NewBusinessCode(15006, "You joined this power not more than 10 days ago", myerr.BusinessData{})               // 加入国家势力不超过10天
	GroupPowerDealerNotMember   = myerr.NewBusinessCode(15007, "Not family member", myerr.BusinessData{})                                             // 代理转账失败-非家族成员
	GroupPowerDealerCanNotSole  = myerr.NewBusinessCode(15008, "This user already has a family agent and cannot sell diamonds", myerr.BusinessData{}) // 代理转账失败-此用户已有家族代理，不能出售钻石
	GroupPowerDealerCanNotBuy   = myerr.NewBusinessCode(15009, "Buy diamonds from your family agent", myerr.BusinessData{})                           // 请向本家族代理购买钻石
	GroupPowerDealerNeedJoin    = myerr.NewBusinessCode(15010, "Please join the agent's family to purchase", myerr.BusinessData{})                    // 请加入代理的家族后进行购买
	GroupPowerHaveNoJoin        = myerr.NewBusinessCode(15011, "You have no joined power", myerr.BusinessData{})                                      // 还未加入国家势力
	GroupPowerHaveNoPower       = myerr.NewBusinessCode(15012, "You have no power", myerr.BusinessData{})                                             // 没有权限
	GroupPowerHaveNoApply       = myerr.NewBusinessCode(15013, "User have no apply", myerr.BusinessData{})                                            // 没有找到申请
	GroupPowerHaveAlreadyApply  = myerr.NewBusinessCode(15014, "Already applied", myerr.BusinessData{})                                               // 已经申请过
	GroupPowerHaveAlreadyChange = myerr.NewBusinessCode(15015, "Already changed", myerr.BusinessData{})                                               // 已经改变了
	GroupPowerHaveChangeInfo    = myerr.NewBusinessCode(15016, "Setting failed", myerr.BusinessData{})                                                // 修改失败
	GroupPowerHaveTooLong       = myerr.NewBusinessCode(15017, "too long", myerr.BusinessData{})                                                      // 长度太长
	GroupPowerCannotRepeated    = myerr.NewBusinessCode(15018, "Cannot be repeated", myerr.BusinessData{})                                            // 不能重复
	GroupPowerCannotQuit        = myerr.NewBusinessCode(15019, "Cannot quit", myerr.BusinessData{})                                                   // 不能退出
	GroupPowerUserHaveNoJoin    = myerr.NewBusinessCode(15020, "User have no joined power", myerr.BusinessData{})                                     // 还未加入国家势力
	GroupPowerChangeNameplate   = myerr.NewBusinessCode(15021, "Can only be modified at the silver level", myerr.BusinessData{})                      // 修改铭牌不够等级
	GroupPowerMemberMax         = myerr.NewBusinessCode(15022, "The family size has reached the upper limit", myerr.BusinessData{})                   // 家族人数达到上限
	GroupPowerCannotJoin        = myerr.NewBusinessCode(15023, "You cannot join", myerr.BusinessData{})                                               // 不能加入家族
	DealerCannotSaleToOtherArea = myerr.NewBusinessCode(15024, "Fail", myerr.BusinessData{})                                                          // 代理转账失败-不同地区

	TaskHasAward = myerr.NewBusinessCode(19001, "task has award", myerr.BusinessData{})

	//贵族
	NobleNoMicSpeechCloseLevel5     = myerr.NewBusinessCode(21001, "Can't mute the King", myerr.BusinessData{})              //无法禁言贵族5
	NobleNoKickLevel5               = myerr.NewBusinessCode(21002, "Can't kick the King", myerr.BusinessData{})              //无法禁言贵族5
	NobleNoMicSpeechCloseOverLevel5 = myerr.NewBusinessCode(21003, "Unable to mute VIP5 and VIP6", myerr.BusinessData{})     //无法禁言贵族5、6
	NobleNoKickOverLevel5           = myerr.NewBusinessCode(21004, "Unable to kick out VIP5 and VIP6", myerr.BusinessData{}) //无法踢出贵族5、6

	// 超级管理人
	OfficialStaffLimit = myerr.NewBusinessCode(22001, "Operation failed", myerr.BusinessData{})

	ManagerNoPermission     = myerr.NewBusinessCode(27001, "没有权限进行重置删除操作", myerr.BusinessData{})
	ManagerNoUserPermission = myerr.NewBusinessCode(27002, "没有权限对该用户进行重置删除操作", myerr.BusinessData{})
	GamingCannotKick        = myerr.NewBusinessCode(27050, "The game has already started and the user cannot be kicked out", myerr.BusinessData{}) // 游戏已经开始，不能踢出用户

)
