package groupPower_c

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/redis_key/groupPower_k"
	"time"
)

type GroupPowerGradeExp struct {
	GroupPowerId mysql.ID
	Exp          mysql.Num
	UserId       mysql.ID
	Remark       string
	Ts           int64
}

// redis队列缓冲GroupPowerGradeExp升级内容
func QueueGroupPowerGradeExp(model *domain.Model, groupPowerId mysql.ID, exp mysql.Num, userId mysql.ID, remark string) error {
	queue := groupPower_k.GetGroupPowerGradeExpQueue()
	data := GroupPowerGradeExp{
		GroupPowerId: groupPowerId,
		Exp:          exp,
		UserId:       userId,
		Remark:       remark,
		Ts:           time.Now().Unix(),
	}
	body, _ := json.Marshal(data)
	return model.Redis.RPush(model, queue, string(body)).Err()
}

// redis弹出GroupPowerGradeExp升级内容
func BLPopGroupPowerGradeExp(model *domain.Model) *GroupPowerGradeExp {
	var res *GroupPowerGradeExp
	queue := groupPower_k.GetGroupPowerGradeExpQueue()
	strs, err := model.Redis.BLPop(model, time.Second, queue).Result()
	if err != nil {
		model.Log.Errorf("BLPopGroupPowerGradeExp fail:%v", err)
		return nil
	}
	if len(strs) >= 2 {
		content := strs[1]
		res = new(GroupPowerGradeExp)
		if err := json.Unmarshal([]byte(content), res); err != nil {
			model.Log.Errorf("BLPopGroupPowerGradeExp json fail:%v", err)
			return nil
		}
		return res
	}
	return nil
}
