package group_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type BuyGroupCustomThemeEvent struct {
	GroupCustomThemeId mysql.ID
	UserId             mysql.ID
}

//注册监听
var buyGroupCustomThemeListen = new(domain.EventBase)

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddBuyGroupCustomThemeSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(buyGroupCustomThemeListen, callback)
}

//加入到异步操作中
func AddBuyGroupCustomThemeAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(buyGroupCustomThemeListen, callback)
}

//领域事件发布
func PublishBuyGroupCustomTheme(model *domain.Model, event *BuyGroupCustomThemeEvent) error {
	return domain.PublishEvent(buyGroupCustomThemeListen, model, event)
}
