package group_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type GroupSupportEvent struct {
	GroupSupportAwardAdmin GroupSupportItem
	GroupCode              string
	GroupSupportAwardMgrs  []GroupSupportItem
}

type GroupSupportItem struct {
	GroupSupportAwardId mysql.ID
	UserId              mysql.ID
	DiamondNum          uint32
}

func InitGroupSupportEvent(size int, groupCode string) *GroupSupportEvent {
	return &GroupSupportEvent{GroupSupportAwardMgrs: make([]GroupSupportItem, 0, size), GroupCode: groupCode}
}

func (groupSupportEvent *GroupSupportEvent) AddAdmin(groupSupportAwardId mysql.ID, userId mysql.ID, diamondNum uint32) *GroupSupportEvent {
	groupSupportEvent.GroupSupportAwardAdmin = GroupSupportItem{
		GroupSupportAwardId: groupSupportAwardId,
		UserId:              userId,
		DiamondNum:          diamondNum,
	}
	return groupSupportEvent
}

func (groupSupportEvent *GroupSupportEvent) AddMgr(groupSupportAwardId mysql.ID, userId mysql.ID, diamondNum uint32) *GroupSupportEvent {
	groupSupportEvent.GroupSupportAwardMgrs = append(groupSupportEvent.GroupSupportAwardMgrs, GroupSupportItem{
		GroupSupportAwardId: groupSupportAwardId,
		UserId:              userId,
		DiamondNum:          diamondNum,
	})
	return groupSupportEvent
}

//注册监听
var groupSupportListen = new(domain.EventBase)

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupSupportSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupSupportListen, callback)
}

//加入到异步操作中
func AddGroupSupportAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupSupportListen, callback)
}

//领域事件发布
func PublishGroupSupport(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(groupSupportListen, model, event)
}
