package group_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

var txGroupInListen = new(domain.EventBase)

// 进房事件
type TxGroupInEvent struct {
	GroupId    string // imGroupId
	UserId     mysql.ID
	ExternalId string
	Nick       string
	Avatar     string
	IsMember   bool //是否永久成员
	IsVip      bool
	NobleLevel uint16
}

func AddTxGroupInEventSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(txGroupInListen, callback)
}

func AddTxGroupInEventAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(txGroupInListen, callback)
}

func PublishTxGroupInEvent(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(txGroupInListen, model, event)
}
