package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"hilo-group/_const/enum/group_e"
)

type GroupSetting struct {
	mysql.Entity
	GroupId         string
	DiceNum         uint16
	DiceType        uint16
	ProfitAllocator uint64
	IsHidden        bool
}

// 冲突时只更新diceNum
func (gs *GroupSetting) SetDiceNum(db *gorm.DB) error {
	return db.Clauses(clause.OnConflict{
		DoUpdates: clause.AssignmentColumns([]string{"dice_num"}),
	}).Create(gs).Error
}

// 冲突时只更新diceType
func (gs *GroupSetting) SetDiceType(db *gorm.DB) error {
	return db.Clauses(clause.OnConflict{
		DoUpdates: clause.AssignmentColumns([]string{"dice_type"}),
	}).Create(gs).Error
}

// 冲突时只更新IsHidden
func (gs *GroupSetting) SetIsHidden(db *gorm.DB) error {
	gs.DiceNum = group_e.GROUP_DICE_NUM_DEFAULT
	return db.Clauses(clause.OnConflict{
		DoUpdates: clause.AssignmentColumns([]string{"is_hidden"}),
	}).Create(gs).Error
}

func (gs *GroupSetting) GetHidden(db *gorm.DB) (map[string]struct{}, error) {
	rows := make([]GroupSetting, 0)
	result := make(map[string]struct{}, 0)
	gs.IsHidden = true
	if err := db.Where(gs).Find(&rows).Error; err != nil {
		return nil, err
	}
	for _, i := range rows {
		result[i.GroupId] = struct{}{}
	}
	return result, nil
}

func IsHiddenGroup(db *gorm.DB, groupId string) (bool, error) {
	gs := GroupSetting{IsHidden: true}
	hiddenGroups, err := gs.GetHidden(db)

	if err != nil {
		return false, err
	} else {
		_, ok := hiddenGroups[groupId]
		return ok, nil
	}
}

func IsHiddenGroupBy(model *domain.Model, imGroupId string) bool {
	info := new(GroupSetting)
	if err := model.DB().Model(GroupSetting{}).Where("group_id = ? and is_hidden = 1", imGroupId).First(&info).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return false
		}
		return false
	}
	if info != nil && info.ID > 0 {
		return true
	}
	return false
}

func (gs *GroupSetting) Get(db *gorm.DB) error {
	return db.Where(gs).First(gs).Error
}

func GetProfitAllocator(model *domain.Model, groupId string) (uint64, error) {
	gs := GroupSetting{GroupId: groupId}
	err := gs.Get(model.Db)
	if err != nil && err != gorm.ErrRecordNotFound {
		return 0, err
	}

	if gs.ProfitAllocator > 0 {
		return gs.ProfitAllocator, nil
	} else {
		owner, err := GetGroupOwner(model, groupId)
		if err != nil {
			return 0, err
		}
		return owner, nil
	}
}
