package version_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type VersionControl struct {
	mysql.Entity
	Platform     mysql.Str
	AuditVersion mysql.Str
	Status       mysql.YesNo
}

// 获取所有版本控制
func GetVersionControlByPlatform(model *domain.Model, platform string) *VersionControl {
	res := new(VersionControl)
	if err := model.Db.Model(VersionControl{}).Where("platform = ?", platform).First(&res).Error; err != nil {
		model.Log.Errorf("GetVersionControlByPlatform fail:%v", err)
	}
	if res.Status != mysql.YES {
		res.AuditVersion = "999.999.999" // 不生效设置为无限大
	}
	return res
}
