package event_s

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/rpc"
	"git.hilo.cn/hilo-common/sdk/tencentyun"
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/_const/enum/group_e"
	"hilo-group/_const/enum/msg_e"
	"hilo-group/_const/enum/task_e"
	"hilo-group/domain/cache/groupPower_c"
	"hilo-group/domain/cache/group_c"
	"hilo-group/domain/event/gift_ev"
	"hilo-group/domain/event/group_ev"
	"hilo-group/domain/event/group_power_ev"
	"hilo-group/domain/event/mic_ev"
	"hilo-group/domain/model/diamond_m"
	"hilo-group/domain/model/groupPower_m"
	"hilo-group/domain/model/group_m"
	"hilo-group/domain/model/mic_m"
	"hilo-group/domain/model/msg_m"
	"hilo-group/domain/model/task_m"
	"hilo-group/domain/model/user_m"
	"hilo-group/domain/service/group_mic_s"
	"hilo-group/myerr"
	"strconv"
	"time"
)

func EventInit() {
	GroupPowerEvents()
	GroupSupportEvents()
	GroupEvents()
	GroupImMass()
	GroupTheme()
	SendGift()              // 送礼事件
	OnMic()                 // 在麦上事件
	GroupInMicChangeEvent() // 用户进房推送mic位置信息
}

func GroupSupportEvents() {
	//群组支持
	group_ev.AddGroupSupportSync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupSupportEvent)
		if !ok {
			model.Log.Errorf("AddGroupSupportSync fail data")
			return nil
		}
		model.Log.Infof("diamond AddGroupSupport admin:%v mgrs:%v", event.GroupSupportAwardAdmin, event.GroupSupportAwardMgrs)
		diamondAccountAdmin, err := diamond_m.GetDiamondAccountByUserId(model, event.GroupSupportAwardAdmin.UserId)
		if err != nil {
			return err
		}
		diamondAccountDetailAdmin, err := diamondAccountAdmin.GroupSupportAdmin(event.GroupSupportAwardAdmin.GroupSupportAwardId, event.GroupSupportAwardAdmin.DiamondNum)
		if err != nil {
			return err
		}
		if err := diamondAccountDetailAdmin.Persistent(); err != nil {
			return err
		}
		for i, _ := range event.GroupSupportAwardMgrs {
			diamondAccount, err := diamond_m.GetDiamondAccountByUserId(model, event.GroupSupportAwardMgrs[i].UserId)
			if err != nil {
				return err
			}
			diamondAccountDetail, err := diamondAccount.GroupSupportMgr(event.GroupSupportAwardMgrs[i].GroupSupportAwardId, event.GroupSupportAwardMgrs[i].DiamondNum)
			if err != nil {
				return err
			}
			if err := diamondAccountDetail.Persistent(); err != nil {
				return err
			}
		}
		return nil
	})

	//群组支持奖励
	group_ev.AddGroupSupportAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupSupportEvent)
		if !ok {
			model.Log.Errorf("AddGroupSupportSync fail data")
			return nil
		}
		model.Log.Infof("msg AddGroupSupportAsync admin:%v, mgr:%v", event.GroupSupportAwardAdmin, event.GroupSupportAwardMgrs)
		for i, _ := range event.GroupSupportAwardMgrs {
			user, err := user_m.GetUser(model, event.GroupSupportAwardMgrs[i].UserId)
			if err != nil {
				model.Log.Errorf("msg AddGroupSupportAsync GetUser userId:%v, err:%v", event.GroupSupportAwardMgrs[i].UserId, err)
			}
			if err := msg_m.NewUserRecord(model, user.ID, msg_e.GroupSupport, user.Nick, user.ID, strconv.FormatUint(uint64(event.GroupSupportAwardMgrs[i].DiamondNum), 10), "", "", "", event.GroupCode).Persistent(); err != nil {
				model.Log.Errorf("msg AddGroupSupportAsync NewUserRecord err:%v", err)
				break
			}
			msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
		}
		user, err := user_m.GetUser(model, event.GroupSupportAwardAdmin.UserId)
		if err != nil {
			model.Log.Errorf("msg AddGroupSupportAsync GetUser userId:%v, err:%v", event.GroupSupportAwardAdmin.UserId, err)
		}
		if err := msg_m.NewUserRecord(model, user.ID, msg_e.GroupSupport, user.Nick, user.ID, strconv.FormatUint(uint64(event.GroupSupportAwardAdmin.DiamondNum), 10), "", "", "", event.GroupCode).Persistent(); err != nil {
			model.Log.Errorf("msg AddGroupSupportAsync NewUserRecord err:%v", err)
			return nil
		}
		msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
		return nil
	})

}

func GroupPowerEvents() {
	// 加入势力
	group_power_ev.AddGroupPowerJoinAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_power_ev.GroupPowerJoinEvent)
		if !ok {
			model.Log.Errorf("AddGroupPowerJoinAsync event type err")
			return nil
		}
		model.Log.Infof("msg AddGroupPowerJoinAsync UserId:%v, GroupPowerId:%v", event.UserId, event.GroupPowerId)
		//获取势力主
		mgrUserId, err := groupPower_m.GetGroupPowerMgr(model, event.GroupPowerId)
		if err != nil {
			return err
		}
		mgrUser, err := user_m.GetUser(model, mgrUserId)
		if err != nil {
			return err
		}
		joinUser, err := user_m.GetUser(model, event.UserId)
		if err != nil {
			return err
		}
		if err := msg_m.NewUserRecord(model, mgrUser.ID, msg_e.GroupPowerUserJoin, joinUser.Nick, joinUser.ID, "", "", "", "", "").Persistent(); err != nil {
			model.Log.Errorf("msg AddGroupPowerJoinAsync NewUserRecord err:%v", err)
			return nil
		}
		msg_m.SendEmasMsgAssistant(model, mgrUser.ExternalId, mgrUser.DeviceType)
		return nil
	})
	// 离开势力
	group_power_ev.AddGroupPowerLeaveAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_power_ev.GroupPowerLeaveEvent)
		if !ok {
			model.Log.Errorf("AddGroupPowerLeaveAsync event type err")
			return nil
		}
		model.Log.Infof("msg AddGroupPowerLeaveAsync UserId:%v, GroupPowerId:%v", event.UserId, event.GroupPowerId)
		//获取势力主
		mgrUserId, err := groupPower_m.GetGroupPowerMgr(model, event.GroupPowerId)
		if err != nil {
			return err
		}
		mgrUser, err := user_m.GetUser(model, mgrUserId)
		if err != nil {
			return err
		}
		joinUser, err := user_m.GetUser(model, event.UserId)
		if err != nil {
			return err
		}
		if err := msg_m.NewUserRecord(model, mgrUser.ID, msg_e.GroupPowerUserLeave, joinUser.Nick, joinUser.ID, "", "", "", "", "").Persistent(); err != nil {
			model.Log.Errorf("msg AddGroupPowerLeaveAsync NewUserRecord err:%v", err)
			return nil
		}
		msg_m.SendEmasMsgAssistant(model, mgrUser.ExternalId, mgrUser.DeviceType)
		return nil
	})
	// 势力升级
	group_power_ev.AddGroupPowerUpgradeAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_power_ev.GroupPowerUpgradeEvent)
		if !ok {
			model.Log.Errorf("AddGroupPowerUpgradeAsync event type err")
			return nil
		}
		model.Log.Infof("msg AddGroupPowerUpgradeAsync GroupPowerId:%v", event.GroupPowerId)
		users, err := groupPower_m.GetGroupPowerUser(model, event.GroupPowerId)
		if err != nil {
			return err
		}
		var userIds []mysql.ID
		for _, u := range users {
			userIds = append(userIds, u.UserId)
		}
		userMaps, err := user_m.GetUserMapByIds(model, userIds)
		if err != nil {
			return err
		}
		for uid, u := range userMaps {
			if err := msg_m.NewUserRecord(model, uid, msg_e.GroupPowerUpgrade, "", 0, "", "", "", "", "").Persistent(); err != nil {
				model.Log.Errorf("msg AddGroupPowerLeaveAsync NewUserRecord err:%v", err)
				return nil
			}
			msg_m.SendEmasMsgAssistant(model, u.ExternalId, u.DeviceType)
		}
		return nil
	})

	// 势力等级即将过期
	group_power_ev.AddGroupPowerExpireNoticeAsync(func(model *domain.Model, e interface{}) error {
		start := time.Now()
		model.Log.Infof("msg AddGroupPowerExpireNoticeAsync,start:%v", start)
		lastId := mysql.ID(0)
		for {
			powerUsers, nextLastId, err := groupPower_m.BatchGetAllGroupPowerUsers(model, lastId, 500)
			if err != nil {
				model.Log.Errorf("AddGroupPowerExpireNoticeAsync fail:%v", err)
				return err
			}
			if len(powerUsers) <= 0 {
				break
			}
			userMaps, err := user_m.GetUserMapByIds(model, powerUsers)
			if err != nil {
				return err
			}
			for uid, u := range userMaps {
				if err := msg_m.NewUserRecord(model, uid, msg_e.GroupPowerExpireNotice, "", 0, "", "", "", "", "").Persistent(); err != nil {
					model.Log.Errorf("msg AddGroupPowerExpireNoticeAsync NewUserRecord err:%v", err)
					return nil
				}
				_ = msg_m.SendEmasMsgAssistant(model, u.ExternalId, u.DeviceType)
			}
			if nextLastId <= 0 {
				break
			}
			lastId = nextLastId
			time.Sleep(time.Second) // 停顿一秒
		}
		model.Log.Infof("msg AddGroupPowerExpireNoticeAsync,end:%v", time.Now().Sub(start).Seconds())
		return nil
	})
}

func GroupEvents() {
	// 进房事件
	group_ev.AddGroupInAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupInEvent)
		if !ok {
			model.Log.Errorf("AddGroupInAsync for room: %+v", event)
			return nil
		}
		model.Log.Infof("AddGroupInAsync for room: %+v", event)

		uer := group_m.UserEnterRoom{
			UserId:    event.UserId,
			GroupId:   event.GroupId,
			EnterTime: time.Now(),
		}
		err := uer.Save(model.Db)
		model.Log.Infof("AddGroupInAsync, UserEnterRoom err: %v", err)
		group_c.ZAddUserEnterRoom(model, event.UserId, event.GroupId) // redis存储
		return err
	})

	// 进入房间时，
	group_ev.AddGroupInAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupInEvent)
		if !ok {
			model.Log.Errorf("AddGroupInAsync for room: %+v", event)
			return nil
		}
		model.Log.Infof("AddGroupInAsync for user: %+v", event)

		user, err := user_m.GetUser(model, event.UserId)
		if err != nil {
			return err
		}

		medals, err := user_m.GetUserMedalMerge(model.Log, model.Db, event.UserId)
		if err != nil {
			model.Log.Errorf("tim_m user AddGroupInAsync GetUserMedal err:%v, userId:%v", err, event.UserId)
			return err
		}

		wealthGrade, _, err := user_m.GetWealthGrade(model, event.UserId)
		if err != nil {
			return err
		}

		charmGrade, _, err := user_m.GetCharmGrade(model, event.UserId)
		if err != nil {
			return err
		}

		if err = FlushGrades(event.ExternalId, wealthGrade, charmGrade); err != nil {
			model.Log.Info("AddGroupInAsync, FlushGrades failed: ", err)
		}

		_, powerName, err := groupPower_m.GetUserGroupPower(model, event.UserId)
		if err != nil {
			return err
		}

		if err = FlushHiloInfo(user.ExternalId, event.IsVip, user.Code != user.OriginCode, medals, powerName, event.NobleLevel); err != nil {
			model.Log.Info("AddGroupInAsync, FlushHiloInfo failed: ", err)
		}
		return nil
	})
	//被踢出
	group_ev.AddGroupKickOutAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupKickOutEvent)
		if !ok {
			model.Log.Errorf("AddGroupKickOutAsync fail data")
			return nil
		}
		model.Log.Infof("publicScreenMsg AddGroupKickOutAsync GroupId:%v, OperatorExternalId:%v, MemberExternalId:%v", event.GroupId, event.OperatorExternalId, event.MemberExternalId)

		groupKickOutMsg := group_m.CommonPublicMsg{
			Type:               group_e.UserKickPublicScreenMsg,
			OperatorExternalId: event.OperatorExternalId,
			OperatorNick:       event.OperatorName,
			OperatorAvatar:     event.OperatorFaceUrl,
			ExternalId:         event.MemberExternalId,
			Nick:               event.MemberName,
			Avatar:             event.MemberAvatar,
		}
		//
		body, err := json.Marshal(groupKickOutMsg)
		if err != nil {
			return myerr.WrapErr(err)
		}

		txGroupId, err := group_m.ToTxGroupId(model, event.GroupId)
		if err != nil {
			return err
		}
		//发送公屏消息,
		u, err := tencentyun.SendCustomMsg(model.Log, txGroupId, nil, string(body), "")
		model.Log.Infof("publicScreenMsg AddGroupKickOutAsync result response.MsgSeq:%v, err:%v", u, err)
		return err
	})
}

func GroupImMass() {
	//支付群主群发IM
	group_ev.AddGroupImMassSync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupImMassEvent)
		if !ok {
			model.Log.Errorf("AddGroupImMassSync data fail")
			return nil
		}
		model.Log.Infof("diamond AddGroupImMass groupId:%v userId:%v", event.GroupId, event.UserId)
		diamondAccount, err := diamond_m.GetDiamondAccountByUserId(model, event.UserId)
		if err != nil {
			return err
		}
		diamondAccountDetail, err := diamondAccount.GroupImMass()
		if err != nil {
			return err
		}
		return diamondAccountDetail.Persistent()
	})

	// 任务
	group_ev.AddGroupImMassAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupImMassEvent)
		if !ok {
			model.Log.Errorf("AddGroupImMassSync data fail")
			return nil
		}
		model.Log.Infof("task AddGroupImMassAsync %+v", event)
		_, err := task_m.AddTaskUser(model, task_e.GroupImMass, event.UserId, 0)
		return err
	})

	// 麦上的人/管理员群发消息，弹窗 fixme:放在这里已经不合适了
	group_ev.AddGroupImMassAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupImMassEvent)
		if !ok {
			model.Log.Errorf("AddGroupImMassSync data fail")
			return nil
		}
		model.Log.Infof("AddGroupImMassAsync begin groupId = %s, userId %d, members: %v, content: %s",
			event.GroupId, event.UserId, event.Members, event.Content)

		flag, err := group_m.IsHiddenGroup(model.Db, event.GroupId)
		if err != nil {
			return err
		}
		if flag {
			model.Log.Infof("AddGroupImMassAsync, skip hidden group %s", event.GroupId)
			return nil
		}

		if len(event.Members) <= 0 {
			return nil
		}
		user, err := user_m.GetUser(model, event.UserId)
		if err != nil {
			return err
		}

		//过滤用户黑名单，只要单方面拉黑就不发
		memberUserIds, err := user_m.FilterBlock(model, event.UserId, event.Members)
		if err != nil {
			return err
		}

		groupInfo, err := group_m.GetGroupInfo(model, event.GroupId)
		if err != nil {
			return err
		}

		userInCount, err := group_m.GetRoomVisitCount(event.GroupId)
		if err != nil {
			return err
		}
		if userInCount < 0 {
			userInCount = 0
		}

		// 注意发消息使用了TxGroupId
		err = rpc.SendGroupChatNotice(event.UserId, memberUserIds, user.ExternalId, user.Code, uint32(user.Sex), user.Avatar,
			event.Content, groupInfo.TxGroupId, groupInfo.Name, groupInfo.Code, groupInfo.FaceUrl, uint32(userInCount))
		model.Log.Infof("AddGroupImMassAsync, groupId = %s ended, err = %v", event.GroupId, err)
		return nil
	})

}

func GroupTheme() {
	//购买自定义主题
	group_ev.AddBuyGroupCustomThemeSync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.BuyGroupCustomThemeEvent)
		if !ok {
			model.Log.Errorf("AddBuyGroupCustomThemeSync data fail")
			return nil
		}
		model.Log.Infof("diamond AddBuyGroupCustomTheme userId:%v, GroupCustomThemeId:%v", event.UserId, event.GroupCustomThemeId)
		diamondAccount, err := diamond_m.GetDiamondAccountByUserId(model, event.UserId)
		if err != nil {
			return err
		}
		diamondAccountDetail, err := diamondAccount.BuyGroupCustomTheme(event.GroupCustomThemeId)
		if err != nil {
			return err
		}
		if err := diamondAccountDetail.Persistent(); err != nil {
			return err
		}
		return nil
	})
}

func FlushGrades(userExtId string, wealthGrade uint32, charmGrade uint32) error {
	level := (charmGrade & 0x000000FF << 8) | wealthGrade&0x000000FF

	return tencentyun.SetUserLevel(userExtId, level)
}

type TimHiloInfo struct {
	IsVip      bool     `json:"isVip"`
	IsPretty   bool     `json:"isPretty"`
	Medals     []uint32 `json:"medals"`
	PowerName  string   `json:"powerName"` // 用户加入的国家势力的绑定群组的名称
	NobleLevel uint16   `json:"nobleLevel"`
}

func FlushHiloInfo(extId string, isVip bool, isPrettyCode bool, medals []uint32, groupPowerName string, nobleLevel uint16) error {
	info := TimHiloInfo{IsVip: isVip, IsPretty: isPrettyCode, Medals: medals, PowerName: groupPowerName, NobleLevel: nobleLevel}
	buf, err := json.Marshal(info)
	if err != nil {
		return err
	}

	if err = tencentyun.SetUserHiloInfo(extId, string(buf)); err != nil {
		return err
	}
	return nil
}

func SendGift() {
	// 送礼事件-势力经验
	gift_ev.AddSendGiftEventAsync(func(model *domain.Model, event interface{}) error {
		sendGiftEvent, ok := event.(*gift_ev.SendGiftEvent)
		if !ok {
			model.Log.Errorf("AddSendGiftEventAsync event type err")
			return nil
		}
		model.Log.Infof("AddSendGiftEventAsync %+v", sendGiftEvent)
		if sendGiftEvent.ResGift.GiftType != mysql.DiamondYellow {
			return nil
		}
		exist, groupPowerId, err := groupPower_m.CheckGroupPowerUser(model, sendGiftEvent.SendUserId)
		if err != nil {
			model.Log.Infof("CheckGroupPowerUser fail %+v", err)
			return err
		}
		if exist {
			exp := sendGiftEvent.GiftN * mysql.Num(len(sendGiftEvent.ReceiveUserIds)) * sendGiftEvent.ResGift.DiamondNum
			//return model.Transaction(func(model *domain.Model) error {
			//	return groupPower_m.IncrGroupPowerExp(model, groupPowerId, exp, sendGiftEvent.SendUserId, "送礼")
			//})
			return groupPower_c.QueueGroupPowerGradeExp(model, groupPowerId, exp, sendGiftEvent.SendUserId, "送礼")
		}
		return nil
	})
	// 家族之星-送礼/收礼
	gift_ev.AddSendGiftEventAsync(func(model *domain.Model, event interface{}) error {
		sendGiftEvent, ok := event.(*gift_ev.SendGiftEvent)
		if !ok {
			model.Log.Errorf("AddSendGiftEventAsync event type err")
			return nil
		}
		if sendGiftEvent.ResGift.GiftType != mysql.DiamondYellow {
			return nil
		}
		var userIds = []mysql.ID{sendGiftEvent.SendUserId}
		userIds = append(userIds, sendGiftEvent.ReceiveUserIds...)
		groupPowers, err := groupPower_m.BatchGetGroupPowerUser(model, userIds)
		if err != nil {
			model.Log.Errorf("AddSendGiftEventAsync fail:%v", err)
			return err
		}
		// 送礼加分
		if data, ok := groupPowers[sendGiftEvent.SendUserId]; ok {
			diamonds := sendGiftEvent.GiftN * sendGiftEvent.ResGift.DiamondNum * mysql.Num(len(sendGiftEvent.ReceiveUserIds))
			if err := groupPower_m.IncrGroupPowerMonthStarScore(model, data.GroupPowerId, data.UserId, groupPower_e.GroupPowerStarTypeFamous, diamonds, 0); err != nil {
				model.Log.Errorf("IncrGroupPowerMonthStarScore famous fail:%v", err)
			}
			if err := groupPower_m.IncrGroupPowerDayStarScore(model, data.GroupPowerId, data.UserId, groupPower_e.GroupPowerStarTypeFamous, diamonds, 0); err != nil {
				model.Log.Errorf("IncrGroupPowerDayStarScore famous fail:%v", err)
			}
		}
		// 收礼加分
		for _, userId := range sendGiftEvent.ReceiveUserIds {
			if data, ok := groupPowers[userId]; ok {
				diamonds := sendGiftEvent.GiftN * sendGiftEvent.ResGift.DiamondNum
				if err := groupPower_m.IncrGroupPowerMonthStarScore(model, data.GroupPowerId, data.UserId, groupPower_e.GroupPowerStarTypeCharm, diamonds, 0); err != nil {
					model.Log.Errorf("IncrGroupPowerMonthStarScore charm fail:%v", err)
				}
				if err := groupPower_m.IncrGroupPowerDayStarScore(model, data.GroupPowerId, data.UserId, groupPower_e.GroupPowerStarTypeCharm, diamonds, 0); err != nil {
					model.Log.Errorf("IncrGroupPowerDayStarScore charm fail:%v", err)
				}
			}
		}
		return nil
	})
}

func OnMic() {
	// 上麦经验/上麦时长
	mic_ev.AddOnMicEventAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*mic_ev.OnMicEvent)
		if !ok {
			model.Log.Errorf("AddOnMicEventSync event type err")
			return nil
		}
		if err := group_mic_s.NewGroupPowerService(model.MyContext).IncrGroupPowerOnMicExpAndTime(event.GroupUuid, event.UserId, event.Timestamp); err != nil {
			model.Log.Errorf("cron micIn GroupPowerOnMicExp err:%v", err)
		} else {
			model.Log.Infof("cron micIn GroupPowerOnMicExp success, groupId:%v, userId:%v", event.GroupUuid, event.UserId)
		}
		return nil
	})
	// 用户上麦时长
	mic_ev.AddOnMicEventAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*mic_ev.OnMicEvent)
		if !ok {
			model.Log.Errorf("AddOnMicEventSync event type err")
			return nil
		}
		if err := mic_m.IncrUserOnMic(model, event.UserId, event.Timestamp); err != nil {
			model.Log.Errorf("cron micIn IncrUserOnMic err:%v", err)
		} else {
			model.Log.Infof("cron micIn IncrUserOnMic success,userId:%v", event.UserId)
		}
		// 处理活动数据 活动已经结束
		//go rpc.AddActPoint(model, event.UserId, 1, 0)
		return nil
	})
}
