package group_e

import "git.hilo.cn/hilo-common/resource/mysql"

type MsgStatusGroupUser = mysql.Type

const (
	//正常: 灰点+震动
	NormalMsgStatusGroupUser MsgStatusGroupUser = 0
	//静音：灰点
	MuteMsgStatusGroupUser MsgStatusGroupUser = 1
	//免打扰：什么也没有
	DoNotDisturbMsgStatusGroupUser MsgStatusGroupUser = 2

	OverseaRoom = 1
	LocalRoom   = 2
)

// 公屏消息
type TypePublicScreenMsg = mysql.Type

const (
	UserJoinPublicScreenMsg     TypePublicScreenMsg = 1  // 加入群组
	UserKickPublicScreenMsg     TypePublicScreenMsg = 2  // 踢出房间
	UserBannedPublicScreenMsg   TypePublicScreenMsg = 3  // 拉黑用户
	RoleAssignedPublicScreenMsg TypePublicScreenMsg = 4  // 添加角色
	RoleRemovedPublicScreenMsg  TypePublicScreenMsg = 5  // 移除角色
	ClientSendMsgLocal          TypePublicScreenMsg = 6  // 客户端占用
	RollDiceMsg                 TypePublicScreenMsg = 7  // 掷骰子结果
	GroupGiftMsg                TypePublicScreenMsg = 8  //全服礼物
	GroupSupportH5              TypePublicScreenMsg = 9  //群组支持H5
	JumpMessage                 TypePublicScreenMsg = 10 // 可跳转的公屏消息
	RocketAwardMsg              TypePublicScreenMsg = 11 // 火箭获奖消息
	LockyboxAwardMsg            TypePublicScreenMsg = 12 // 幸运盒子公屏中奖
	FruitMachineAwardMsg        TypePublicScreenMsg = 13 // 水果机中奖
	EnterRoomMsg                TypePublicScreenMsg = 14 // 用户进入房间
)

// 信令消息（不显示公屏工，不记入消息历史，不影响未读数）
type TypeSignalMsg = mysql.Type

const (
	GroupEditProfileSignal    TypeSignalMsg = 1
	GroupRoleChangeSignal     TypeSignalMsg = 2
	GroupMicChangeSignal      TypeSignalMsg = 3 //保留
	GroupMsgBannedSignal      TypeSignalMsg = 4
	GroupMemberRemoveSignal   TypeSignalMsg = 5
	GroupGiftSignal           TypeSignalMsg = 6 //礼物
	GroupMicInSignal          TypeSignalMsg = 7
	GroupMicOutSignal         TypeSignalMsg = 8
	GroupMicLockSignal        TypeSignalMsg = 9
	GroupMicUnLockSignal      TypeSignalMsg = 10
	GroupMicSpeechOpenSignal  TypeSignalMsg = 11
	GroupMicSpeechCloseSignal TypeSignalMsg = 12
	GroupKickOut              TypeSignalMsg = 13 //保留
	GroupSocketMicOutSignal   TypeSignalMsg = 14 //保留
	GroupInviteMicInSignal    TypeSignalMsg = 15 //邀请上麦保留
	GroupInSignal             TypeSignalMsg = 16 //进入房间,进房特效
	GroupMicEmoji             TypeSignalMsg = 17 //麦上表情
	GroupLuckyWheel           TypeSignalMsg = 18 //转盘的通知信令
	GroupOutSignal            TypeSignalMsg = 19 //离开房间
	GroupRocketState          TypeSignalMsg = 20 //火箭状态变化
	GroupOnlineUser           TypeSignalMsg = 21 //房间在线用户信息
	GroupMicChange            TypeSignalMsg = 22 //房间麦位上的变量
	GroupMemberInvite         TypeSignalMsg = 23 //房间-邀请用户成为会员
	GroupRoleChange           TypeSignalMsg = 24 //房间-用户群组身份变化
	GroupClearScreen          TypeSignalMsg = 25 //房间-清理公屏
)

//群组麦位数量类型
type GroupMicNumType = mysql.Type

const (
	OneMicNumType       GroupMicNumType = 5
	TwoMicNumType       GroupMicNumType = 10
	ThreeMicNumType     GroupMicNumType = 3
	FourMicNumType      GroupMicNumType = 4
	SixMicNumType       GroupMicNumType = 6
	SevenMicNumType     GroupMicNumType = 7
	EightMicNumType     GroupMicNumType = 8
	NineMicNumType      GroupMicNumType = 9
	ElevenMicNumType    GroupMicNumType = 11
	TwelveMicNumType    GroupMicNumType = 12
	ThirteenMicNumType  GroupMicNumType = 13
	FourteenMicNumType  GroupMicNumType = 14
	FifteenMicNumType   GroupMicNumType = 15
	SixteenMicNumType   GroupMicNumType = 16
	SeventeenMicNumType GroupMicNumType = 17
	EighteenMicNumType  GroupMicNumType = 18
	NineteenMicNumType  GroupMicNumType = 19
	TwentyMicNumType    GroupMicNumType = 20
	//5个麦位
	FiveMicNumType GroupMicNumType = 1
	//10个麦位
	TenMicNumType GroupMicNumType = 2
	//

	SUPPORT_LEVEL_BOUNDARY_HOUR = 0
	SUPPORT_LEVEL_PERIOD_DAY    = 7
)

type GroupRoleType = uint16

const (
	// 群组角色
	GROUP_VISITOR GroupRoleType = 0   // 游客
	GROUP_MEMBER  GroupRoleType = 1   // 成员
	GROUP_ADMIN   GroupRoleType = 10  // 管理员
	GROUP_MANAGER GroupRoleType = 50  // 经理
	GROUP_OWNER   GroupRoleType = 100 // owner
)

// 群组内游戏相关
const (
	GROUP_DICE_NUM_DEFAULT = 5
	GROUP_DICE_NUM_MAX     = 5
)

const DefaultMsgParallelSize = 20
const (
	CREATE_GROUP_MAX_ATTEMPT = 10
	OldGroupNamePrefix       = "@TGS#"
	NewGroupNamePrefix       = "HTGS#"
	OverseaGroupNamePrefix   = NewGroupNamePrefix + "a"
)

var GROUP_RECOMMEND_SIZE = 5
var GROUP_CREATE_LIMIT = 1
var GROUP_DEFAULT_CODE_LENGTH uint16 = 8

const (
	// 上下架状态
	SWITCH_ON = 1
	SWITH_OFF = 0
)

var GROUP_ROLE_VIEW_LIMIT = 10
var GROUP_INTRODUCTION_LENGTH_LIMIT = 500

const ROOM_PASSWORD_LENGTH = 4
const SETTING_CUSTOMIZED = 2
const SETTING_OFFICIAL = 1

type AddGroupResultType = uint

const (
	ADD_GROUP_DONE      AddGroupResultType = 1
	ADD_GROUP_DUPLICATE AddGroupResultType = 2
	ADD_GROUP_PENDING   AddGroupResultType = 3
	ADD_GROUP_FAILED    AddGroupResultType = 0
)

var GROUP_DEFAULT_JOIN_LIMIT uint = 200
var GROUP_VIP_JOIN_LIMIT uint = 500
var GROUP_NOBLE4_JOIN_LIMIT uint = 1000
var GROUP_ROLE_PERSONAL_VIEW_LIMIT = 5
var GROUP_MANAGER_LIMIT uint = 30
var GROUP_ADMIN_LIMIT uint = 50

type GroupProvider = uint8

const (
	// 群组声音供应商
	GroupProvider_SW   GroupProvider = 1 // 声网
	GroupProvider_TRTC GroupProvider = 2 // 腾讯trtc
)
