package groupPower_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/common"
	"hilo-group/common/utime"
	"hilo-group/myerr"
	"hilo-group/myerr/bizerr"
	"time"
)

//type GroupPowerGrade struct {
//	GroupPowerId uint64    `json:"group_power_id"`
//	Exp          int64     `json:"exp"`
//	Grade        int32     `json:"grade"`
//	ExpireAt     time.Time `json:"expire_at"`
//}

type GroupPowerQuitLog struct {
	Id           uint64    `json:"id"`
	UserId       uint64    `json:"user_id"`
	MgrId        uint64    `json:"mgr_id"`
	CreatedTime  time.Time `json:"created_time"`
	GroupPowerId uint64    `json:"group_power_id"`
}

func (this *GroupPower) Get(model *domain.Model) (*GroupPower, error) {
	group := new(GroupPower)
	err := model.Db.Where(this).First(&group).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		}
		return nil, err
	}
	grade := new(GroupPowerGrade)
	err = model.Db.Model(&GroupPowerGrade{}).Where("group_power_id=? and expire_at > ?", this.ID, time.Now().Format(utime.Layout)).First(&grade).Error
	if err != nil && err != gorm.ErrRecordNotFound {
		return nil, err
	}
	if grade.GroupPowerId > 0 {
		group.Grade = mysql.Num(grade.Grade)
		group.Exp = mysql.Num(grade.Exp)
		group.NextExp = mysql.Num(grade.Exp)
	}
	return group, nil
}

func (gpu *GroupPowerUser) GetBy(model *domain.Model, pageSize, pageIndex int) ([]*GroupPowerUser, int64, int, bool, error) {
	rows := make([]*GroupPowerUser, 0)
	db := model.Db.Model(GroupPowerUser{}).Where(gpu).Order("field(`role`, 2, 3, 1)")
	var count int64
	err := db.Count(&count).Error
	if err != nil {
		return nil, 0, 0, false, err
	}
	err = db.Limit(pageSize).Offset(pageIndex - 1).Find(&rows).Error
	if err != nil {
		return nil, 0, 0, false, err
	}
	nextPageIndex, hasNextPage := common.PageNext(count, pageIndex, pageSize)
	return rows, count, nextPageIndex, hasNextPage, nil
}

func (gpu *GroupPowerUser) GetGroupPowerUser(model *domain.Model) (*GroupPowerUser, error) {
	rows := make([]*GroupPowerUser, 0)
	err := model.Db.Where(gpu).Find(&rows).Error
	if err != nil {
		return nil, err
	}
	if len(rows) == 0 {
		return nil, nil
	}
	return rows[0], nil
}

func (gpu *GroupPowerUser) Create(db *gorm.DB) error {
	return db.Create(gpu).Error
}

func QuitFamily(model *domain.Model, userId, mgrId, familyId uint64) error {
	err := model.Db.Exec("delete from group_power_user where group_power_id = ? and user_id = ?", familyId, userId).Error
	if err != nil {
		return err
	}
	// log
	log := &GroupPowerQuitLog{UserId: userId, MgrId: mgrId, GroupPowerId: familyId, CreatedTime: time.Now()}
	return model.Db.Create(log).Error
}

func GroupPowerQuitList(model *domain.Model, familyId uint64, pageSize, pageIndex int) ([]*GroupPowerQuitLog, int, bool, error) {
	rows := make([]*GroupPowerQuitLog, 0)
	db := model.Db.Model(GroupPowerQuitLog{}).Where("group_power_id = ?", familyId).Order("created_time desc")
	var count int64
	err := db.Count(&count).Error
	if err != nil {
		return nil, 0, false, err
	}
	err = db.Limit(pageSize).Offset(pageIndex - 1).Find(&rows).Error
	if err != nil {
		return nil, 0, false, err
	}
	nextIdx, hasNext := common.PageNext(count, pageIndex, pageSize)
	return rows, nextIdx, hasNext, nil
}

func UpdateFamilyAdmin(model *domain.Model, userId, familyId uint64, role groupPower_e.GroupPowerUserRole) error {
	err := model.Db.Exec("update group_power_user set role = ? where group_power_id = ? and user_id = ?", role, familyId, userId).Error
	if err != nil {
		return err
	}
	return nil
}

func UpdateFamily(model *domain.Model, familyId uint64, name, nameplate, declaration, icon string) error {
	if familyId == 0 || (name == "" && nameplate == "" && declaration == "" && icon == "") {
		return nil
	}
	db := model.Db.Model(GroupPower{})
	updateMap := make(map[string]interface{})
	if name != "" {
		updateMap["name"] = name
	}
	if nameplate != "" {
		updateMap["nameplate"] = nameplate
		db = db.Where("not exists (select id from group_power where nameplate = ?)", nameplate)
	}
	if declaration != "" {
		updateMap["declaration"] = declaration
	}
	if icon != "" {
		updateMap["icon"] = icon
	}
	result := db.Updates(updateMap).Limit(1)
	if result.Error != nil {
		return myerr.WrapErr(result.Error)
	}
	if result.RowsAffected <= 0 {
		return myerr.WrapErr(bizerr.GroupPowerHaveChangeInfo)
	}

	return nil
}

func IsExistsNameplate(model *domain.Model, nameplate string) bool {
	var count int64
	err := model.Db.Model(GroupPower{}).Where("nameplate = ?", nameplate).Count(&count).Error
	if err != nil {
		model.Log.Errorf("IsExistsNameplate err:%v, nameplate:%s", err, nameplate)
		return false
	}
	if count > 0 {
		return true
	}
	return false
}
