package groupPower_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"hilo-group/_const/enum/groupPower_e"
	"time"
)

// 家族之星
type GroupPowerMonthStar struct {
	Month        string
	GroupPowerId mysql.ID
	UserId       mysql.ID
	Type         groupPower_e.GroupPowerStarType
	Score        mysql.Num
	LastCalTs    int64
	CreatedTime  time.Time `gorm:"->"`
	UpdatedTime  time.Time `gorm:"->"`
}

// 增加家族之星分数
func IncrGroupPowerMonthStarScore(model *domain.Model, groupPowerId, userId mysql.ID, _type groupPower_e.GroupPowerStarType, score mysql.Num, lastCalTs int64) error {
	month := time.Now().Format("200601")
	star := &GroupPowerMonthStar{
		Month:        month,
		GroupPowerId: groupPowerId,
		UserId:       userId,
		Type:         _type,
		Score:        score,
	}
	if err := model.DB().Model(GroupPowerMonthStar{}).Clauses(clause.OnConflict{
		Columns: []clause.Column{{Name: "month"}, {Name: "group_power_id"}, {Name: "user_id"}, {Name: "type"}},
		DoUpdates: clause.Assignments(map[string]interface{}{
			"score":       gorm.Expr("score + ?", star.Score),
			"last_cal_ts": lastCalTs,
		}),
	}).Create(star).Error; err != nil {
		model.Log.Errorf("IncrGroupPowerMonthStarScore fail:%v", err)
		return err
	}
	return nil
}

// 获取家族之星分数
// 允许返回gorm.ErrRecordNotFound
func GetGroupPowerMonthStar(model *domain.Model, groupPowerId, userId mysql.ID, _type groupPower_e.GroupPowerStarType) (*GroupPowerMonthStar, error) {
	res := new(GroupPowerMonthStar)
	month := time.Now().Format("200601")
	if err := model.DB().Where("month = ? AND group_power_id = ? AND user_id = ? AND `type` = ?", month, groupPowerId, userId, _type).First(res).Error; err != nil {
		return nil, err
	}
	return res, nil
}

// 获取家族之星排行
func GetGroupPowerMonthStarRank(model *domain.Model, groupPowerId mysql.ID, _type groupPower_e.GroupPowerStarType, offset, limit int) ([]*GroupPowerMonthStar, error) {
	var res []*GroupPowerMonthStar
	month := time.Now().Format("200601")
	if err := model.DB().Model(GroupPowerMonthStar{}).Where("month = ? AND group_power_id = ? AND `type` = ?", month, groupPowerId, _type).
		Order("score desc").Offset(offset).Limit(limit).Find(&res).Error; err != nil {
		model.Log.Errorf("GetGroupPowerMonthStarRank fail:%v", err)
		return res, err
	}
	return res, nil
}

// 获取家族之星三个排行榜的各自第一名
func GetGroupPowerMonthStartTop1(model *domain.Model, groupPowerId mysql.ID) ([]*GroupPowerMonthStar, error) {
	var res []*GroupPowerMonthStar
	r1, err := GetGroupPowerMonthStarRank(model, groupPowerId, groupPower_e.GroupPowerStarTypeFamous, 0, 1)
	if err != nil {
		return res, err
	}
	r2, err := GetGroupPowerMonthStarRank(model, groupPowerId, groupPower_e.GroupPowerStarTypeActive, 0, 1)
	if err != nil {
		return res, err
	}
	r3, err := GetGroupPowerMonthStarRank(model, groupPowerId, groupPower_e.GroupPowerStarTypeCharm, 0, 1)
	if err != nil {
		return res, err
	}
	res = append(res, r1...)
	res = append(res, r2...)
	res = append(res, r3...)
	return res, nil
}
