package common

type MsgIdType = uint
type OnlineStatusType = uint
type GroupRoleType = uint16
type AddGroupResultType = uint

const (
	APP_KICKOFF_TIME = "2020-12-19"

	DEFAULT_LANG        = "en"
	DEFAULT_COUNTRY     = "KSA"
	DEFAULT_NICK        = "Hilo No.%s"
	DEFAULT_DESCRIPTION = "Welcome to Hilo"
	DEFAULT_GROUP_NAME  = "Hilo Group NO.%s"

	DefaultAvatarMan   = "hilo/manager/ea48b62d54a24a709de3c38702c89995.png"
	DefaultAvatarWoman = "hilo/manager/ea48b62d54a24a709de3c38702c89995.png"
	// 用户视频最低要求时长
	BASIC_VIDEO_TIME = 1

	// 公会用户视频最低要求时长
	GUILD_USER_VIDEO_TIME = 15

	STATUS_IN_USE = 1
	STATUS_UNUSED = 2

	// 公会用户是否打开通知
	GuildUserNotifyOn  = 1
	GuildUserNotifyOff = 2

	// 平台
	PlatformIOS      = 1
	PlatformGOOGLE   = 2
	PlatformEggPlant = 3 // 通过starchat回调的茄子充值
	PlatformCheckout = 4

	// 加、减
	DIRECTION_ADD    = 1
	DIRECTION_REDUCE = 2

	// 操作类型
	//发送礼物
	OPERATE_TYPE_SENDGIFT = 1
	//匹配条件
	OPERATE_TYPE_MATCHCONDITION = 2
	//建立融云会话
	OPERATE_TYPE_SESSIONPAY = 3
	//购买钻石
	OPERATE_TYPE_BUYDIAMOND = 4
	//接受礼物
	OPERATE_TYPE_RECEIVEGIFT = 5
	//注册
	OPERATE_TYPE_REGISTER = 6
	//平台赠送
	OPERATE_TYPE_MGRSEND = 8

	MATCH_CONFIRM_SUCCESS = 1
	MATCH_CONFIRM_FAIL    = 2
	MATCH_CONFIRM_TEMP    = 3

	ACCEPT_MATCH_CONFIRM = 1
	REFUSE_MATCH_CONFIRM = 2

	// 视频通话是否达标
	VIDEO_EFFECTIVE_YES = 1
	VIDEO_EFFECTIVE_NO  = 2

	// 最大用户相册数
	USER_PHOTO_MAX = 9

	// 上下架状态
	SWITCH_ON = 1
	SWITH_OFF = 0

	// 群组角色
	GROUP_VISITOR GroupRoleType = 0   // 游客
	GROUP_MEMBER  GroupRoleType = 1   // 成员
	GROUP_ADMIN   GroupRoleType = 10  // 管理员
	GROUP_MANAGER GroupRoleType = 50  // 经理
	GROUP_OWNER   GroupRoleType = 100 // owner

	ROOM_PASSWORD_LENGTH     = 4
	CREATE_GROUP_MAX_ATTEMPT = 10

	// 在线状态
	IM_STATUS_OFF_LINE     OnlineStatusType = 0
	IM_STATUS_PUSH_ON_LINE OnlineStatusType = 1
	IM_STATUS_ON_LINE      OnlineStatusType = 2

	MSG_ID_GROUP_NAME         MsgIdType = 101
	MSG_ID_GROUP_INTRODUCTION MsgIdType = 102
	MSG_ID_GROUP_NOTIFICATION MsgIdType = 103
	MSG_ID_GROUP_WELCOME      MsgIdType = 104
	MSG_ID_GROUP_INVITE       MsgIdType = 105
	MSG_ID_GROUP_LEAVE_POWER  MsgIdType = 106
	MSG_ID_ALL_GROUP_ROCKET   MsgIdType = 107
	MSG_ID_ROOM_MEADAL        MsgIdType = 108
	MSG_ID_VIDEO_PUSH_TITITLE MsgIdType = 109
	MSG_ID_VIDEO_PUSH_CONTENT MsgIdType = 110
	MSG_ID_REPEAT_ACCOUNT     MsgIdType = 111
	MSG_ID_USER_TRANSFER      MsgIdType = 114
	MSG_ID_NO_POWER_TO_SVIP6  MsgIdType = 115 // 不能对svip6做某些动作
	// ps:116-138 在hilo-finance定义了!
	MSG_ID_NOT_FAMILY_MEMBER   MsgIdType = 165 // 非家族成员
	MSG_ID_DEALER_CAN_NOT_SOLE MsgIdType = 166 // 此用户已有家族代理，不能出售钻石
	MSG_ID_BUY_FROM_FAMILY     MsgIdType = 167 // 请向本家族代理购买钻石
	MSG_ID_NEED_JOIN_FAMILY    MsgIdType = 168 // 请加入代理的家族后进行购买

	ADD_GROUP_FAILED    AddGroupResultType = 0
	ADD_GROUP_DONE      AddGroupResultType = 1
	ADD_GROUP_DUPLICATE AddGroupResultType = 2
	ADD_GROUP_PENDING   AddGroupResultType = 3

	SETTING_OFFICIAL   = 1
	SETTING_CUSTOMIZED = 2
)

var USER_QPS_DEFAULT_MAX int64 = 15
var HEART_VALUE_MAX uint32 = 2000
var BUILDBOARD_SMALL_SIZE = 30
var BUILDBOARD_SIZE = 50

var GROUP_CREATE_LIMIT = 1
var GROUP_NAME_LENGTH_LIMIT = 30
var GROUP_INTRODUCTION_LENGTH_LIMIT = 500
var GROUP_NOTIFICATION_LENGTH_LIMIT = 150

var MAX_BEAUTIFUL_CODE_LENGTH = 8
var GROUP_DEFAULT_CODE_LENGTH uint16 = 8
var GROUP_DEFAULT_JOIN_LIMIT uint = 200
var GROUP_VIP_JOIN_LIMIT uint = 500
var GROUP_NOBLE4_JOIN_LIMIT uint = 1000

var GROUP_MANAGER_LIMIT uint = 30
var GROUP_ADMIN_LIMIT uint = 50
var GROUP_ROLE_VIEW_LIMIT = 10
var GROUP_ROLE_PERSONAL_VIEW_LIMIT = 5

var GROUP_RECOMMEND_SIZE = 5

var IM_INVALID_USER = "@TLS#NOT_FOUND"

// TIM相关常量
const (
	SYNC_TO_SENDER   = 1
	NOSYNC_TO_SENDER = 2

	TAG_PROFILE_IM_LEVEL = "Tag_Profile_IM_Level"
	TAG_PROFILE_IM_NICK  = "Tag_Profile_IM_Nick"
	TAG_PROFILE_IM_IMAGE = "Tag_Profile_IM_Image"
	TAG_PROFILE_IM_HILO  = "Tag_Profile_Custom_Hilo"
)

// 群组内游戏相关
const (
	GROUP_DICE_NUM_DEFAULT = 5
	GROUP_DICE_NUM_MAX     = 5
)

var PAY_TEST_USERS = []uint64{11, 21, 41, 71, 151, 251, 291, 881, 1041, 4411, 951, 24091}

var ROCKET_STAGE_NUM uint16 = 3
var ROCKET_STAGE_CHANGE_THRESHOLD = 10
var ROCKET_SHOW_DURATION = 10

// RocketAwardType
const (
	ROCKET_AWARD_GUEST_DIAMOND = 0 // 观众分到小额钻石
	ROCKET_AWARD_PROPERTY      = 1 // TOP6抽到的座驾
	ROCKET_AWARD_HEADDRESS     = 2 // TOP6抽到的头饰
	ROCKET_AWARD_DIAMOND       = 3 // TOP6抽到的钻石
)

const DefaultMinimalVersionAndroid = 100
const DefaultMinimalVersionIOS = 100

const DefaultMsgParallelSize = 20

const OldGroupNamePrefix = "@TGS#"
const NewGroupNamePrefix = "HTGS#"
const OverseaGroupNamePrefix = NewGroupNamePrefix + "a"

const (
	SendSmsCodeIpMaxHourTimes       = 20
	SendSmsCodeImeiMaxHourTimes     = 10
	SendSmsCodePhoneMaxHourTimes    = 5
	SendSmsCodeUserMaxHourTimes     = 3
	SendSmsCodeLen                  = 6    // 验证码长度
	SendSmsCodeMaxCheckTimes        = 3    // 验证码最大校验次数
	SendSmsCodeNoUserIdMaxHourTimes = 1000 // 没有传userId调用发短信，5分钟最大次数

	CallbackCheckoutPaySucceed = "payment_captured" // checkout回调支付成功

	// ranking
	RankingDay   = "day"
	RankingWeek  = "week"
	RankingMonth = "month"
	RankingAll   = "all"
	// ranking module
	RankingModulePinkDiamond = "pinkDiamond"

	// giftwall 礼物墙
	GiftWallInitNum        = 15000 // 礼物墙初始化数量
	GiftWallInitOnceSetNum = 500   // 礼物墙初始化，一次插入的数量
	GiftWallStartReduceNum = 20000 // 礼物墙触发清理逻辑数量
	GiftWallReduceNum      = 3000  // 礼物墙触发清理逻辑，清理的数量
)
