package groupPower_k

import (
	"fmt"
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/_const/redis_key"
)

// 家族之星榜单
// type: 1:送礼 2:活跃 3:收礼
// date:天/周/月的开始时间
const GroupPowerStarPrefix = "groupPowerStar:${type}:${period}:${groupPowerId}:${date}" // zset member:userId score:分数

func GetGroupPowerStarRankKey(_type groupPower_e.GroupPowerStarType, period string, groupPowerId uint64, date string) string {
	return redis_key.ReplaceKey(GroupPowerStarPrefix,
		fmt.Sprintf("%d", _type), period, fmt.Sprintf("%d", groupPowerId), date)
}
