package group_power_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type GroupPowerLeaveEvent struct {
	UserId       mysql.ID
	GroupPowerId mysql.ID
}

//注册监听
var groupPowerLeaveListen = new(domain.EventBase)

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupPowerLeaveSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupPowerLeaveListen, callback)
}

//加入到异步操作中
func AddGroupPowerLeaveAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupPowerLeaveListen, callback)
}

//领域事件发布
func PublishGroupPowerLeave(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(groupPowerLeaveListen, model, event)
}
