package group_power_cv

import (
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/cv/user_cv"
)

// 家族信息
type CvGroupPowerInfo struct {
	CvGroupPowerBase   `json:",inline"`
	CvGroupPowerMember `json:",inline"`
	CvGroupPowerGrade  `json:",inline"`
}

// 家族基本信息
type CvGroupPowerBase struct {
	Id        uint64 `json:"id"`        // 家族id
	Icon      string `json:"icon"`      // 家族图片
	Name      string `json:"name"`      // 家族名
	Nameplate string `json:"nameplate"` // 铭牌
}

// 家族成员
type CvGroupPowerMember struct {
	MemberNum uint32 `json:"memberNum"` // 当前成员数
	MemberMax uint32 `json:"memberMax"` // 成员上限
}

// 家族等级
type CvGroupPowerGrade struct {
	Grade    groupPower_e.GroupPowerGrade `json:"grade"`              // 等级 0:无 1:青铜 2:白银 3:黄金 4:黑金
	Exp      uint32                       `json:"exp"`                // 经验值
	NextExp  uint32                       `json:"nextExp,omitempty"`  // 升级所需经验值
	ExpireAt string                       `json:"expireAt,omitempty"` // 有效期
	ShowExp  bool                         `json:"showExp"`            // 是否展示经验值
}

// 家族榜单
type CvGroupPowerRank struct {
	MyGroupPower *CvGroupPowerRankData  `json:"myGroupPower,omitempty"` // 我的家族排名
	Items        []CvGroupPowerRankData `json:"items"`                  // 列表
}

type CvGroupPowerRankData struct {
	CvGroupPowerBase  `json:",inline"`
	CvGroupPowerGrade `json:",inline"`
	Rank              int `json:"rank"` // 排名
}

// 家族之星
type CvGroupPowerStarData struct {
	User  user_cv.CvUserTiny `json:"user"`
	Score uint32             `json:"score"` // 对应分值
}

// 资源等级
type CvResGrade struct {
	Grade   groupPower_e.GroupPowerGrade `json:"grade"`   // 等级
	Icon    string                       `json:"icon"`    // 等级icon
	BigIcon string                       `json:"bigIcon"` // 等级大图标
}

// 特权信息
type CvPrivilege struct {
	Type groupPower_e.GroupPowerPrivilege `json:"type"` // 特权id 1:成员数 2:管理员数 3:家族铭牌 4:家族徽章装饰 5:编辑铭牌 6:家族头饰
	Num  int                              `json:"num"`  // 数目
}

// 家族等级页
type CvGroupPowerGradeDetail struct {
	GroupPowerBase  CvGroupPowerBase  `json:"groupPowerBase"`  // 家族基本信息
	GroupPowerGrade CvGroupPowerGrade `json:"groupPowerGrade"` // 家族等级信息
	ResGradeList    []CvResGrade      `json:"resGradeList"`    // 资源等级列表,青铜、白银、黄金、黑金
	PrivilegeList   []CvPrivilege     `json:"privilegeList"`   // 等级特权
}

var CvResGradeList = []CvResGrade{
	{groupPower_e.GroupPowerGrade0, "青铜icon", "青铜bigIcon"}, // todo
	{groupPower_e.GroupPowerGrade1, "白银icon", "白银bigIcon"}, // todo
	{groupPower_e.GroupPowerGrade2, "黄金icon", "黄金bigIcon"}, // todo
	{groupPower_e.GroupPowerGrade3, "黑金icon", "黑金bigIcon"}, // todo
}

var GroupPowerGradePrivilegeNum = map[groupPower_e.GroupPowerGrade][]CvPrivilege{
	groupPower_e.GroupPowerGrade0: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 300},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 10},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1},
		{groupPower_e.GroupPowerPrivilegeMedal, 1},
	},
	groupPower_e.GroupPowerGrade1: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 500},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 15},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1},
		{groupPower_e.GroupPowerPrivilegeMedal, 1},
		{groupPower_e.GroupPowerPrivilegeNameplateEdit, 1},
	},
	groupPower_e.GroupPowerGrade2: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 800},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 20},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1},
		{groupPower_e.GroupPowerPrivilegeMedal, 1},
		{groupPower_e.GroupPowerPrivilegeNameplateEdit, 1},
		{groupPower_e.GroupPowerPrivilegeNameplateHeadwear, 1},
	},
	groupPower_e.GroupPowerGrade3: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 1200},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 25},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1},
		{groupPower_e.GroupPowerPrivilegeMedal, 1},
		{groupPower_e.GroupPowerPrivilegeNameplateEdit, 1},
		{groupPower_e.GroupPowerPrivilegeNameplateHeadwear, 1},
	},
}
