package event_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

// 进房事件消息
type EventGroupIn struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	Proto         mysql.Type
	Payload       []byte
	Mark          mysql.YesNo
	MarkHiloGroup mysql.YesNo
}

func (EventGroupIn) TableName() string {
	return "event_group_in"
}

// 偏移值
type EventGroupInOffsetHiloGroup struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	MarkOffset    mysql.ID
}

// 获取当前偏移值
func GroupOffset(model *domain.Model) (*EventGroupInOffsetHiloGroup, error) {
	offset := new(EventGroupInOffsetHiloGroup)
	if err := model.Db.WithContext(model).First(offset).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("Offset fail:%v", err)
			return nil, err
		}
		// gorm.ErrRecordNotFound
	}
	offset.Model = model
	return offset, nil
}

// 批量获取进房事件
func FetchEventGroupIn(model *domain.Model, limit int) ([]*EventGroupIn, *EventGroupInOffsetHiloGroup, error) {
	offset, err := GroupOffset(model)
	if err != nil {
		return nil, nil, err
	}
	var events []*EventGroupIn
	if err := model.Db.WithContext(model).Model(EventGroupIn{}).
		Where("id > ?", offset.MarkOffset).
		Order("id asc").Limit(limit).Find(&events).Error; err != nil {
		model.Log.Errorf("FetchEventGroupIn fail:%v", err)
		return nil, nil, err
	}
	return events, offset, nil
}

// 标记已完成
func (p *EventGroupIn) MarkDone() error {
	p.MarkHiloGroup = mysql.YES
	return p.Db.WithContext(p.Model).Model(EventGroupIn{}).Where("id = ?", p.ID).Update("mark_hilo_group", p.MarkHiloGroup).Limit(1).Error
}
