package res_m

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/msg_e"
	"hilo-group/myerr"
)

type ResCode struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	Code          string
}

/**
 * true: 不存在成功， false: 已存在，不成功
 */
func CheckCode(model *domain.Model, code string) (bool, error) {
	var n int64
	if err := model.Db.Model(&ResCode{
		Code: code,
	}).Count(&n).Error; err != nil {
		return false, myerr.WrapErr(err)
	}
	if n == 0 {
		return true, nil
	} else {
		return false, nil
	}
}

func GetErrByLanguage(db *gorm.DB, msgId msg_e.MsgIdType, lang string, myErr *myerr.BusinessError, args ...interface{}) *myerr.BusinessError {
	var msg string
	if len(args) > 0 {
		msg = fmt.Sprintf(myErr.GetMsg(), args...)
	} else {
		msg = myErr.GetMsg()
	}
	if resMul, _ := GetResMultiTextBy(db, msgId, lang); resMul != nil {
		if len(args) > 0 {
			msg = fmt.Sprintf(resMul.Content, args...)
		} else {
			msg = resMul.Content
		}
	}
	return myerr.NewBusinessCodeNoCheck(myErr.GetCode(), msg, myerr.BusinessData{})
}
