package res_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type ResMicEmoji struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	Name          mysql.Str
	IconUrl       mysql.Str
	SvagUrl       mysql.Str
	N             mysql.Num
	Status        mysql.UserYesNo
}

//不可用
func (resMicEmoji *ResMicEmoji) Disable() *ResMicEmoji {
	resMicEmoji.Status = mysql.NOUSER
	return resMicEmoji
}

//上架
func (resMicEmoji *ResMicEmoji) Enable() *ResMicEmoji {
	resMicEmoji.Status = mysql.USER
	return resMicEmoji
}

func (resMicEmoji *ResMicEmoji) EditN(n uint32) *ResMicEmoji {
	resMicEmoji.N = n
	return resMicEmoji
}

func (resMicEmoji *ResMicEmoji) EditName(name string) *ResMicEmoji {
	resMicEmoji.Name = name
	return resMicEmoji
}

func (resMicEmoji *ResMicEmoji) EditIconUrl(iconUrl string) *ResMicEmoji {
	resMicEmoji.IconUrl = iconUrl
	return resMicEmoji
}

func (resMicEmoji *ResMicEmoji) EditSvagUrl(svagUrl string) *ResMicEmoji {
	resMicEmoji.SvagUrl = svagUrl
	return resMicEmoji
}
