package res_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/res_e"
	"hilo-group/myerr"
)

type ResGroupSupport struct {
	mysql.Entity
	*domain.Model        `gorm:"-"`
	Grade                res_e.ResGroupSupportGrade
	ContributeUserNum    mysql.Num
	ContributeDiamondNum mysql.Num
	MgrNum               mysql.Num
	AdminAward           mysql.Num
	MgrAward             mysql.Num
	Status               mysql.UserYesNo
}

func GetResGroupSupportById(model *domain.Model, id mysql.ID) (ResGroupSupport, error) {
	resGroupSupport := ResGroupSupport{}
	if err := model.Db.Model(&ResGroupSupport{}).Where(&ResGroupSupport{Status: mysql.USER}).First(&resGroupSupport, id).Error; err != nil {
		return ResGroupSupport{}, myerr.WrapErr(err)
	}
	return resGroupSupport, nil
}

func GetResGroupSupportByValid(model *domain.Model) ([]ResGroupSupport, error) {
	resGroupSupports := []ResGroupSupport{}
	if err := model.Db.Model(&ResGroupSupport{}).Where(&ResGroupSupport{
		Status: mysql.USER,
	}).Order("grade asc").Find(&resGroupSupports).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	return resGroupSupports, nil
}

func GetResGroupSupportBy(model *domain.Model, contributeUserNum uint32, contributeDiamondNum uint64) (*ResGroupSupport, error) {
	resGroupSupport := ResGroupSupport{}
	if err := model.Db.Model(&ResGroupSupport{}).Where(&ResGroupSupport{
		Status: mysql.USER,
	}).Where("contribute_user_num <= ? AND contribute_diamond_num <= ?", contributeUserNum, contributeDiamondNum).Order("grade DESC").First(&resGroupSupport).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return &resGroupSupport, nil
}
