package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
)

//用户设备
type UserImei struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Imei          mysql.Str
}

func getUserImeiOrCreate(model *domain.Model, userId mysql.ID) (*UserImei, error) {
	var userImei UserImei
	if err := model.Db.Where(&UserImei{
		UserId: userId,
	}).First(&userImei).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			userImei.UserId = userId
			//userImei.Imei = imei
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	/*	else {
		if userImei.Imei == imei {
			userImei.SetLasyLoad()
		} else {
			userImei.Imei = imei
		}
	}*/
	userImei.Model = model
	return &userImei, nil
}

func GetUserImeiStr(model *domain.Model, userId mysql.ID) (string, error) {
	var userImei UserImei
	if err := model.Db.Where(&UserImei{
		UserId: userId,
	}).First(&userImei).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return "", nil
		} else {
			return "", myerr.WrapErr(err)
		}
	}
	return userImei.Imei, nil
}

func (userImei *UserImei) updateImei(imei mysql.Str) {
	if userImei.Imei == imei {
		userImei.SetLasyLoad()
	} else {
		userImei.Imei = imei
	}
}

//统计imei数量
func countImei(model *domain.Model, imei string) (int64, error) {
	var c int64 = 0
	if err := model.Db.Model(&UserImei{}).Where(&UserImei{
		Imei: imei,
	}).Count(&c).Error; err != nil {
		return 0, myerr.WrapErr(err)
	}
	return c, nil
}

func ImeiUserIds(model *domain.Model, imei string) ([]uint64, error) {
	rows := []UserImei{}
	if err := model.Db.Model(&UserImei{}).Where(&UserImei{
		Imei: imei,
	}).Find(&rows).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	userIds := make([]uint64, 0, len(rows))
	for _, i := range rows {
		userIds = append(userIds, i.UserId)
	}
	return userIds, nil
}

func GetSameImeiUsers(model *domain.Model, userId uint64) ([]uint64, error) {
	userImei, err := getUserImeiOrCreate(model, userId)
	if err != nil {
		return nil, err
	}

	if len(userImei.Imei) <= 0 {
		return nil, nil
	}
	userIds, err := ImeiUserIds(model, userImei.Imei)
	if err != nil {
		return nil, err
	}
	return userIds, nil
}

func GetSameImeiMap(model *domain.Model, userId uint64) (map[uint64]uint64, error) {
	rows, err := GetSameImeiUsers(model, userId)
	if err != nil {
		return nil, err
	}
	result := make(map[uint64]uint64, 0)
	for _, i := range rows {
		result[i] = userId
	}
	return result, nil
}
