package signal_s

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/sdk/tencentyun"
	"github.com/sirupsen/logrus"
	"hilo-group/domain/model/group_m"
	"runtime/debug"
)

// 发送群信令。入参是内部imGroupId，这里做转换
func SendSignalMsg(model *domain.Model, groupId string, msg group_m.GroupSystemMsg, async bool) {
	model.Log.WithField("groupId", groupId)

	groupId, err := group_m.ToTxGroupId(model, groupId)
	if err != nil {
		return
	}

	buffer, err := json.Marshal(msg)
	if err == nil {
		str := string(buffer)
		model.Log.Infof("SendSignalMsg: %s, async = %v", str, async)

		if async {
			go func(logger *logrus.Entry) {
				defer func() {
					if r := recover(); r != nil {
						//打印错误堆栈信息
						logger.Errorf("SendSignalMsg SYSTEM ACTION PANIC: %v, stack: %v", r, string(debug.Stack()))
					}
				}()
				if err = tencentyun.SendSystemMsg(logger, groupId, []string{}, str); err != nil {
					logger.Errorf("SendSignalMsg aync failed for %s, msgId = %d, context:%v, err:%v", groupId, msg.MsgId, str, err)
				} else {
					logger.Infof("SendSignalMsg aync success for %s, msgId = %d, context:%v", groupId, msg.MsgId, str)
				}
			}(model.Log)
		} else if err = tencentyun.SendSystemMsg(model.Log, groupId, []string{}, str); err != nil {
			model.Log.Errorf("SendSignalMsg sync failed for %s, msgId = %d, context:%v, err:%v", groupId, msg.MsgId, str, err)
		} else {
			model.Log.Infof("SendSignalMsg sync success for %s, msgId = %d, context:%v", groupId, msg.MsgId, str)
		}
	} else {
		model.Log.Errorf("Marshall failure, msgId = %d : %s", msg.MsgId, err.Error())
	}
}

func SendCustomMsg(model *domain.Model, groupId string, fromAccount *string, content string) (uint, error) {
	groupId, err := group_m.ToTxGroupId(model, groupId)
	if err != nil {
		return 0, err
	}
	hiloUserInfo := ""
	if fromAccount != nil {
		hiloUserInfo = group_m.GetHiloUserInfo(model, *fromAccount)
	}
	return tencentyun.SendCustomMsg(model.Log, groupId, fromAccount, content, hiloUserInfo)
}
