package group_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

/**
* IM群发
 */
type GroupImMassEvent struct {
	GroupId string
	UserId  mysql.ID
	Members []uint64
	Content string
}

//注册监听
var groupImMassListen = new(domain.EventBase)

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupImMassSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupImMassListen, callback)
}

//加入到异步操作中
func AddGroupImMassAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupImMassListen, callback)
}

//领域事件发布
func PublishGroupImMass(model *domain.Model, event *GroupImMassEvent) error {
	return domain.PublishEvent(groupImMassListen, model, event)
}
